/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.EOFException;
import java.io.InputStream;
import java.util.Arrays;
import skyview.survey.DSSImage;

public class HDecompressor {
    private static final int SIZEBUF = 8192;
    private static final double log2 = Math.log(2.0);
    private static final int[] code_magic = new int[]{221, 153};
    private byte[] buf = new byte[8192];
    private int ptBuf = 0;
    private int maxBuf = 0;
    private InputStream dis;
    private int nx;
    private int ny;
    private int nel;
    private int scale;
    private int[] a;
    private int buffer;
    private int bits_to_go;
    private int[] nbitplanes = new int[3];
    private byte[] scratch;
    private int[] tmp;
    private boolean[] flag;
    boolean debug = true;

    public HDecompressor() {
    }

    public HDecompressor(InputStream dis) {
        this();
        this.setInputStream(dis);
    }

    public void setInputStream(InputStream dis) {
        this.dis = dis;
    }

    public static int[] decompress(InputStream fdis) throws Exception {
        HDecompressor hd = new HDecompressor(fdis);
        hd.decompress();
        return hd.getImage();
    }

    public void decompress() throws Exception {
        this.decode();
        this.undigitize();
        if (this.tmp == null || this.tmp.length < Math.max(this.nx, this.ny)) {
            this.tmp = new int[Math.max(this.nx, this.ny)];
            this.flag = new boolean[Math.max(this.nx, this.ny)];
        }
        this.hinv();
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public int[] getImage() {
        return this.a;
    }

    private int getc() throws Exception {
        while (this.ptBuf == this.maxBuf) {
            this.ptBuf = 0;
            this.maxBuf = this.dis.read(this.buf, 0, this.buf.length);
            if (this.maxBuf != -1) continue;
            throw new EOFException();
        }
        if (this.debug) {
            this.debug = false;
        }
        return this.buf[this.ptBuf++] & 0xFF;
    }

    private int getint() throws Exception {
        return this.getc() << 24 | this.getc() << 16 | this.getc() << 8 | this.getc();
    }

    private void start_inputing_bits() {
        this.bits_to_go = 0;
    }

    private int input_bit() throws Exception {
        if (this.bits_to_go == 0) {
            this.buffer = this.getc();
            this.bits_to_go = 8;
        }
        return this.buffer >> --this.bits_to_go & 1;
    }

    private int input_nbits(int n) throws Exception {
        if (this.bits_to_go < n) {
            this.buffer <<= 8;
            this.buffer |= this.getc();
            this.bits_to_go += 8;
        }
        this.bits_to_go -= n;
        return this.buffer >> this.bits_to_go & (1 << n) - 1;
    }

    private int input_huffman() throws Exception {
        int c = this.input_nbits(3);
        if (c < 4) {
            return 1 << c;
        }
        c = this.input_bit() | c << 1;
        if (c < 13) {
            switch (c) {
                case 8: {
                    return 3;
                }
                case 9: {
                    return 5;
                }
                case 10: {
                    return 10;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 15;
                }
            }
        }
        if ((c = this.input_bit() | c << 1) < 31) {
            switch (c) {
                case 26: {
                    return 6;
                }
                case 27: {
                    return 7;
                }
                case 28: {
                    return 9;
                }
                case 29: {
                    return 11;
                }
                case 30: {
                    return 13;
                }
            }
        }
        if ((c = this.input_bit() | c << 1) == 62) {
            return 0;
        }
        return 14;
    }

    private void qtree_bitins(byte[] d, int nx, int ny, int off, int n, int bit) {
        byte dc;
        int j;
        int s00;
        int i;
        int nxN = nx - 1;
        int nyN = ny - 1;
        int c = 0;
        for (i = 0; i < nxN; i += 2) {
            s00 = off + n * i;
            int s10 = s00 + n;
            for (j = 0; j < nyN; j += 2) {
                dc = d[c];
                int n2 = s10 + 1;
                this.a[n2] = this.a[n2] | (dc & 1) << bit;
                int n3 = s10;
                this.a[n3] = this.a[n3] | (dc >> 1 & 1) << bit;
                int n4 = s00 + 1;
                this.a[n4] = this.a[n4] | (dc >> 2 & 1) << bit;
                int n5 = s00;
                this.a[n5] = this.a[n5] | (dc >> 3 & 1) << bit;
                s00 += 2;
                s10 += 2;
                ++c;
            }
            if (j >= ny) continue;
            dc = d[c];
            int n6 = s10;
            this.a[n6] = this.a[n6] | (dc >> 1 & 1) << bit;
            int n7 = s00;
            this.a[n7] = this.a[n7] | (dc >> 3 & 1) << bit;
            ++c;
        }
        if (i < nx) {
            s00 = off + n * i;
            for (j = 0; j < nyN; j += 2) {
                dc = d[c];
                int n8 = s00 + 1;
                this.a[n8] = this.a[n8] | (dc >> 2 & 1) << bit;
                int n9 = s00;
                this.a[n9] = this.a[n9] | (dc >> 3 & 1) << bit;
                s00 += 2;
                ++c;
            }
            if (j < ny) {
                int n10 = s00;
                this.a[n10] = this.a[n10] | (d[c] >> 3 & 1) << bit;
                ++c;
            }
        }
    }

    private void read_bdirect(int off, int n, int nqx, int nqy, byte[] scratch, int bit) throws Exception {
        int j = (nqx + 1) / 2 * ((nqy + 1) / 2);
        for (int i = 0; i < j; ++i) {
            scratch[i] = (byte)this.input_nbits(4);
        }
        this.qtree_bitins(scratch, nqx, nqy, off, n, bit);
    }

    private void qtree_copy(byte[] d, int nx, int ny, byte[] b, int n) {
        byte bs00;
        int j;
        int s00;
        int i;
        int nxN = nx - 1;
        int nyN = ny - 1;
        int nx2 = (nx + 1) / 2;
        int ny2 = (ny + 1) / 2;
        int k = ny2 * (nx2 - 1) + ny2 - 1;
        for (i = nx2 - 1; i >= 0; --i) {
            s00 = n * i + ny2 - 1 << 1;
            for (j = ny2 - 1; j >= 0; --j) {
                b[s00] = d[k--];
                s00 -= 2;
            }
        }
        for (i = 0; i < nxN; i += 2) {
            s00 = n * i;
            int s10 = s00 + n;
            for (j = 0; j < nyN; j += 2) {
                bs00 = b[s00];
                b[s10 + 1] = (byte)(bs00 & 1);
                b[s10] = (byte)(bs00 >> 1 & 1);
                b[s00 + 1] = (byte)(bs00 >> 2 & 1);
                b[s00] = (byte)(bs00 >> 3 & 1);
                s00 += 2;
                s10 += 2;
            }
            if (j >= ny) continue;
            bs00 = b[s00];
            b[s10] = (byte)(bs00 >> 1 & 1);
            b[s00] = (byte)(bs00 >> 3 & 1);
        }
        if (i < nx) {
            s00 = n * i;
            for (j = 0; j < nyN; j += 2) {
                bs00 = b[s00];
                b[s00 + 1] = (byte)(bs00 >> 2 & 1);
                b[s00] = (byte)(bs00 >> 3 & 1);
                s00 += 2;
            }
            if (j < ny) {
                b[s00] = (byte)(b[s00] >> 3 & 1);
            }
        }
    }

    private void qtree_expand(byte[] d, int nx, int ny, byte[] b) throws Exception {
        this.qtree_copy(d, nx, ny, b, ny);
        for (int i = nx * ny - 1; i >= 0; --i) {
            if (b[i] == 0) continue;
            b[i] = (byte)this.input_huffman();
        }
    }

    private void qtree_decode(int off, int n, int nqx, int nqy, int nbitplanes) throws Exception {
        int log2n;
        int nqmax = nqx > nqy ? nqx : nqy;
        if (nqmax > 1 << (log2n = (int)(Math.log(nqmax) / log2 + 0.5))) {
            ++log2n;
        }
        int nqx2 = (nqx + 1) / 2;
        int nqy2 = (nqy + 1) / 2;
        if (this.scratch == null || this.scratch.length != nqx2 * nqy2) {
            this.scratch = new byte[nqx2 * nqy2];
        } else {
            Arrays.fill(this.scratch, (byte)0);
        }
        for (int bit = nbitplanes - 1; bit >= 0; --bit) {
            int b = this.input_nbits(4);
            if (b == 0) {
                this.read_bdirect(off, n, nqx, nqy, this.scratch, bit);
                continue;
            }
            if (b != 15) {
                throw new Exception("qtree_decode: bad format code " + b);
            }
            this.scratch[0] = (byte)this.input_huffman();
            int nx = 1;
            int ny = 1;
            int nfx = nqx;
            int nfy = nqy;
            int c = 1 << log2n;
            for (int k = 1; k < log2n; ++k) {
                nx <<= 1;
                ny <<= 1;
                if (nfx <= (c >>= 1)) {
                    --nx;
                } else {
                    nfx -= c;
                }
                if (nfy <= c) {
                    --ny;
                } else {
                    nfy -= c;
                }
                this.qtree_expand(this.scratch, nx, ny, this.scratch);
            }
            this.qtree_bitins(this.scratch, nqx, nqy, off, n, bit);
        }
        this.scratch = null;
    }

    private void dodecode() throws Exception {
        int nx2 = (this.nx + 1) / 2;
        int ny2 = (this.ny + 1) / 2;
        this.start_inputing_bits();
        this.qtree_decode(0, this.ny, nx2, ny2, this.nbitplanes[0]);
        this.qtree_decode(ny2, this.ny, nx2, this.ny / 2, this.nbitplanes[1]);
        this.qtree_decode(this.ny * nx2, this.ny, this.nx / 2, ny2, this.nbitplanes[1]);
        this.qtree_decode(this.ny * nx2 + ny2, this.ny, this.nx / 2, this.ny / 2, this.nbitplanes[2]);
        if (this.input_nbits(4) != 0) {
            System.err.println("dodecode: bad bit plane values\n");
            System.err.println("Last image is:" + DSSImage.lastImage);
            throw new Exception("Error in dodecode decompression");
        }
        this.start_inputing_bits();
        for (int i = 0; i < this.nel; ++i) {
            int aa = this.a[i];
            if (aa == 0 || this.input_bit() == 0) continue;
            this.a[i] = -aa;
        }
    }

    private void decode() throws Exception {
        int q = 0;
        int w = 0;
        this.maxBuf = 0;
        this.ptBuf = 0;
        q = this.getc();
        if (q != code_magic[0] || (w = this.getc()) != code_magic[1]) {
            throw new Exception("Bad magic number");
        }
        this.nx = this.getint();
        this.ny = this.getint();
        this.nel = this.nx * this.ny;
        this.scale = this.getint();
        if (this.a == null || this.a.length != this.nel) {
            this.a = new int[this.nel];
        } else {
            Arrays.fill(this.a, 0);
        }
        int sumall = this.getint();
        this.nbitplanes[0] = this.getc();
        this.nbitplanes[1] = this.getc();
        this.nbitplanes[2] = this.getc();
        this.dodecode();
        this.a[0] = sumall;
    }

    private void undigitize() {
        if (this.scale <= 1) {
            return;
        }
        int i = this.nel - 1;
        while (i >= 0) {
            int n = i--;
            this.a[n] = this.a[n] * this.scale;
        }
    }

    private void hinv() {
        int p00;
        int pend;
        int i;
        int h0;
        int log2n;
        int nmax = this.nx > this.ny ? this.nx : this.ny;
        if (nmax > 1 << (log2n = (int)(Math.log(nmax) / Math.log(2.0) + 0.5))) {
            ++log2n;
        }
        int nxtop = 1;
        int nytop = 1;
        int nxf = this.nx;
        int nyf = this.ny;
        int c = 1 << log2n;
        for (int k = log2n - 1; k > 0; --k) {
            int p002;
            int pend2;
            int i2;
            nxtop <<= 1;
            nytop <<= 1;
            if (nxf <= (c >>= 1)) {
                --nxtop;
            } else {
                nxf -= c;
            }
            if (nyf <= c) {
                --nytop;
            } else {
                nyf -= c;
            }
            this.xunshuffle(this.a, nxtop, nytop, this.ny);
            this.yunshuffle(this.a, nxtop, nytop, this.ny);
            for (i2 = 0; i2 < nxtop - 1; i2 += 2) {
                int hx;
                int h02;
                pend2 = this.ny * i2 + nytop - 1;
                p002 = 0;
                int p10 = 0;
                p002 = this.ny * i2;
                p10 = this.ny * (i2 + 1);
                while (p002 < pend2) {
                    h02 = this.a[p002];
                    hx = this.a[p10];
                    int hy = this.a[p002 + 1];
                    int hc = this.a[p10 + 1];
                    int sum1 = h02 + hx + 1;
                    int sum2 = hy + hc;
                    this.a[p10 + 1] = sum1 + sum2 >> 1;
                    this.a[p10] = sum1 - sum2 >> 1;
                    sum1 = h02 - hx + 1;
                    sum2 = hy - hc;
                    this.a[p002 + 1] = sum1 + sum2 >> 1;
                    this.a[p002] = sum1 - sum2 >> 1;
                    p002 += 2;
                    p10 += 2;
                }
                if (p002 != pend2) continue;
                h02 = this.a[p002];
                hx = this.a[p10];
                this.a[p10] = h02 + hx + 1 >> 1;
                this.a[p002] = h02 - hx + 1 >> 1;
            }
            if (nxtop % 2 != 1) continue;
            i2 = nxtop - 1;
            pend2 = this.ny * i2 + nytop - 1;
            for (p002 = this.ny * i2; p002 < pend2; p002 += 2) {
                h0 = this.a[p002];
                int hy = this.a[p002 + 1];
                this.a[p002 + 1] = h0 + hy + 1 >> 1;
                this.a[p002] = h0 - hy + 1 >> 1;
            }
            if (p002 != pend2) continue;
            this.a[p002] = this.a[p002] + 1 >> 1;
        }
        nxtop <<= 1;
        nytop <<= 1;
        if (nxf <= (c >>= 1)) {
            --nxtop;
        } else {
            nxf -= c;
        }
        if (nyf <= c) {
            --nytop;
        } else {
            nyf -= c;
        }
        if (nxtop != this.nx || nytop != this.ny) {
            System.err.println("hinv: error, final image size is " + nxtop + " x " + nytop + " not " + this.nx + " x " + this.ny);
        }
        this.xunshuffle(this.a, this.nx, this.ny, this.ny);
        this.yunshuffle(this.a, this.nx, this.ny, this.ny);
        for (i = 0; i < this.nx - 1; i += 2) {
            int hx;
            pend = this.ny * i + this.ny - 1;
            p00 = 0;
            int p10 = 0;
            p00 = this.ny * i;
            p10 = p00 + this.ny;
            while (p00 < pend) {
                h0 = this.a[p00];
                hx = this.a[p10];
                int hy = this.a[p00 + 1];
                int hc = this.a[p10 + 1];
                int sum1 = h0 + hx + 2;
                int sum2 = hy + hc;
                this.a[p10 + 1] = sum1 + sum2 >> 2;
                this.a[p10] = sum1 - sum2 >> 2;
                sum1 = h0 - hx + 2;
                sum2 = hy - hc;
                this.a[p00 + 1] = sum1 + sum2 >> 2;
                this.a[p00] = sum1 - sum2 >> 2;
                p00 += 2;
                p10 += 2;
            }
            if (p00 != pend) continue;
            h0 = this.a[p00];
            hx = this.a[p10];
            this.a[p10] = h0 + hx + 2 >> 2;
            this.a[p00] = h0 - hx + 2 >> 2;
        }
        if (this.nx % 2 == 1) {
            i = this.nx - 1;
            pend = this.ny * i + this.ny - 1;
            for (p00 = this.ny * i; p00 < pend; p00 += 2) {
                int h03 = this.a[p00];
                int hy = this.a[p00 + 1];
                this.a[p00 + 1] = h03 + hy + 2 >> 2;
                this.a[p00] = h03 - hy + 2 >> 2;
            }
            if (p00 == pend) {
                this.a[p00] = this.a[p00 + 2] >> 2;
            }
        }
    }

    private void xunshuffle(int[] a, int nx, int ny, int nydim) {
        int nhalf = ny + 1 >> 1;
        for (int j = 0; j < nx; ++j) {
            System.arraycopy(a, j * nydim + nhalf, this.tmp, 0, ny - nhalf);
            int pend = j * nydim;
            int p1 = j * nydim + (nhalf - 1 << 1);
            for (int p2 = j * nydim + nhalf - 1; p2 >= pend; --p2) {
                a[p1] = a[p2];
                p1 -= 2;
            }
            pend = j * nydim + ny;
            int pt = 0;
            p1 = j * nydim + 1;
            while (p1 < pend) {
                a[p1] = this.tmp[pt];
                p1 += 2;
                ++pt;
            }
        }
    }

    private void yunshuffle(int[] a, int nx, int ny, int nydim) {
        for (int j = 0; j < nx; ++j) {
            this.flag[j] = true;
        }
        int oddoffset = (nx + 1) / 2;
        int k = 0;
        for (int j = 1; j < nx; ++j) {
            if (!this.flag[j]) continue;
            this.flag[j] = false;
            k = j >= oddoffset ? (j - oddoffset << 1) + 1 : j << 1;
            if (j == k) continue;
            System.arraycopy(a, nydim * j, this.tmp, 0, ny);
            while (this.flag[k]) {
                this.flag[k] = false;
                int p = nydim * k;
                int pt = 0;
                while (p < nydim * k + ny) {
                    int tt = a[p];
                    a[p] = this.tmp[pt];
                    this.tmp[pt] = tt;
                    ++p;
                    ++pt;
                }
                if (k >= oddoffset) {
                    k = (k - oddoffset << 1) + 1;
                    continue;
                }
                k <<= 1;
            }
            System.arraycopy(this.tmp, 0, a, nydim * k, ny);
            if (j == k) continue;
            System.err.println("error: yunshuffle failed!\nj=" + j + " k=" + k);
        }
    }
}

