/*
 * Decompiled with CFR 0.152.
 */
package skyview.vo;

import java.util.regex.Pattern;

class ConeQualifier {
    private String name;
    private String sValue;
    private String op;
    private double nValue;
    private int column = -1;
    private boolean numeric = false;
    private boolean pattern = false;
    private boolean[] codes = new boolean[3];
    private boolean isNot = false;
    Pattern pat;

    ConeQualifier(String name, String op, String value) {
        this.name = name;
        this.op = op;
        this.sValue = value;
        this.codes[0] = op.indexOf("<") >= 0;
        this.codes[1] = op.indexOf("=") >= 0;
        this.codes[2] = op.indexOf(">") >= 0;
        this.isNot = op.indexOf("!") >= 0;
    }

    void setColumnType(int col, String type) {
        this.column = col;
        if (type.equals("char") || type.equals("unicodeChar")) {
            this.numeric = false;
            if ((this.op.equals("=") || this.op.equals("!=")) && this.sValue.indexOf("*") >= 0) {
                this.pattern = true;
                this.sValue = this.sValue.replace("*", ".*");
                this.pat = Pattern.compile(this.sValue, 2);
            }
        } else {
            this.numeric = true;
            this.nValue = Double.parseDouble(this.sValue);
        }
    }

    String getName() {
        return this.name;
    }

    int getColumn() {
        return this.column;
    }

    boolean check(String test) {
        int code = 0;
        if (!this.numeric) {
            if (this.pattern) {
                return this.pat.matcher(test).matches() != this.isNot;
            }
            code = test.compareToIgnoreCase(this.sValue);
            if (code < 0) {
                code = -1;
            } else if (code > 0) {
                code = 1;
            }
        } else {
            try {
                double val = Double.parseDouble(test);
                if (val < this.nValue) {
                    code = -1;
                } else if (val > this.nValue) {
                    code = 1;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.codes[code + 1] != this.isNot;
    }
}

