/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubClient;

public class BasicClientSet
implements ClientSet {
    private final Map publicIdMap_;

    public BasicClientSet(Comparator clientIdComparator) {
        this.publicIdMap_ = Collections.synchronizedMap(new TreeMap(clientIdComparator));
    }

    public synchronized void add(HubClient client) {
        this.publicIdMap_.put(client.getId(), client);
    }

    public synchronized void remove(HubClient client) {
        this.publicIdMap_.remove(client.getId());
    }

    public synchronized HubClient getFromPublicId(String publicId) {
        return (HubClient)this.publicIdMap_.get(publicId);
    }

    public synchronized HubClient[] getClients() {
        return this.publicIdMap_.values().toArray(new HubClient[0]);
    }

    public synchronized boolean containsClient(HubClient client) {
        return this.publicIdMap_.containsValue(client);
    }
}

