/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.hub.HubProfile;
import org.astrogrid.samp.hub.HubProfileFactory;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.StandardHubProfile;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class StandardHubProfileFactory
implements HubProfileFactory {
    private static final String secretUsage_ = "[-std:secret <secret>]";
    private static final String lockUsage_ = "[-std:httplock]";

    public String getName() {
        return "std";
    }

    public String[] getFlagsUsage() {
        return new String[]{secretUsage_, lockUsage_};
    }

    public HubProfile createHubProfile(List flagList) throws IOException {
        String secret = null;
        boolean httpLock = false;
        Iterator it = flagList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-std:secret")) {
                it.remove();
                if (it.hasNext()) {
                    secret = (String)it.next();
                    it.remove();
                    continue;
                }
                throw new IllegalArgumentException("Usage: [-std:secret <secret>]");
            }
            if (arg.equals("-std:httplock")) {
                it.remove();
                httpLock = true;
                continue;
            }
            if (!arg.equals("-std:nohttplock")) continue;
            it.remove();
            httpLock = false;
        }
        File lockfile = httpLock ? null : SampUtils.urlToFile(StandardClientProfile.getLockUrl());
        XmlRpcKit xmlrpc = XmlRpcKit.getInstance();
        if (secret == null) {
            secret = StandardHubProfile.createSecret();
        }
        return new StandardHubProfile(xmlrpc.getClientFactory(), xmlrpc.getServerFactory(), lockfile, secret);
    }

    public Class getHubProfileClass() {
        return StandardHubProfile.class;
    }
}

