<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- for every car element where cost is less than value -->
<xsl:template match="car[@cost &lt; @value]">
      <xsl:copy>
           <!-- copy everything EXCEPT the cost attribute -->
           <xsl:copy-of  select="@*[name() != 'cost']"/>
           <!-- create a new cost attribute.. -->
           <xsl:attribute name="cost">
               <!-- ...and make it's contents the contents of the attribute called value -->
               <xsl:value-of select="@value" />
           </xsl:attribute>
           <xsl:apply-templates/>
      </xsl:copy> 

</xsl:template>




<!-- Basic identitiy stylesheet - just copies everything -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>