/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.gui.SQLDialog;
import uk.ac.starlink.table.gui.SaveWorker;
import uk.ac.starlink.table.gui.TableSaveDialog;
import uk.ac.starlink.table.jdbc.JDBCFormatter;
import uk.ac.starlink.table.jdbc.WriteMode;

public class SQLWriteDialog
extends SQLDialog
implements TableSaveDialog {
    private JDialog dialog_;
    private JComboBox modeSelector_ = new JComboBox<WriteMode>(WriteMode.getAllModes());

    public SQLWriteDialog() {
        super("Write New SQL Table");
        this.modeSelector_.setSelectedItem(WriteMode.CREATE);
        this.getStack().addLine("Write Mode", null, this.modeSelector_);
    }

    public String getName() {
        return "SQL Table";
    }

    public String getDescription() {
        return "Write table as a new table in an SQL relational database";
    }

    public boolean showSaveDialog(Component parent, StarTableOutput sto, ComboBoxModel formatModel, StarTable table) {
        this.useAuthenticator(sto.getJDBCHandler().getAuthenticator());
        JDialog dialog = this.createDialog(parent, "Write New SQL Table");
        final boolean[] done = new boolean[1];
        while (!done[0]) {
            dialog.show();
            if (this.getValue() instanceof Integer && (Integer)this.getValue() == 0) {
                SaveWorker worker = new SaveWorker(parent, table, this.getRef()){

                    public void attemptSave(StarTable table) throws IOException {
                        WriteMode mode = (WriteMode)SQLWriteDialog.this.modeSelector_.getSelectedItem();
                        Connection conn = null;
                        try {
                            conn = SQLWriteDialog.this.getConnector().getConnection();
                            new JDBCFormatter(conn, table).createJDBCTable(SQLWriteDialog.this.getRef(), mode);
                        }
                        catch (SQLException e) {
                            throw (IOException)new IOException(e.getMessage()).initCause(e);
                        }
                        finally {
                            if (conn != null) {
                                try {
                                    conn.close();
                                }
                                catch (SQLException e) {}
                            }
                        }
                    }

                    public void done(boolean success) {
                        done[0] = success;
                    }
                };
                this.setEnabled(false);
                worker.invoke();
                this.setEnabled(true);
                continue;
            }
            return false;
        }
        return true;
    }
}

