/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.Figure;
import diva.canvas.connector.Connector;
import java.util.EventObject;

public class ConnectorEvent
extends EventObject {
    public static final int CONNECTOR_DRAGGED = 12;
    public static final int CONNECTOR_DROPPED = 13;
    public static final int CONNECTOR_SNAPPED = 14;
    public static final int CONNECTOR_UNSNAPPED = 15;
    public static final int HEAD_END = 21;
    public static final int TAIL_END = 22;
    public static final int BOTH_ENDS = 23;
    public static final int MIDPOINT = 24;
    private int _id;
    private int _end;
    private Figure _target;
    private Connector _connector;

    public ConnectorEvent(int id, Object source, Figure target, Connector connector, int end) {
        super(source);
        this._target = target;
        this._id = id;
        this._connector = connector;
        this._end = end;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public int getEnd() {
        return this._end;
    }

    public int getID() {
        return this._id;
    }

    public Figure getTarget() {
        return this._target;
    }

    private String idToString() {
        switch (this.getID()) {
            case 12: {
                return "CONNECTOR_DRAGGED";
            }
            case 13: {
                return "CONNECTOR_DROPPED";
            }
            case 14: {
                return "CONNECTOR_SNAPPED";
            }
            case 15: {
                return "CONNECTOR_UNSNAPPED";
            }
        }
        return "Invalid event ID";
    }

    private String endToString() {
        switch (this.getEnd()) {
            case 21: {
                return "HEAD_END";
            }
            case 22: {
                return "TAIL_END";
            }
            case 23: {
                return "BOTH_ENDS";
            }
        }
        return "Invalid end.";
    }

    public String toString() {
        return "ConnectorEvent[" + this.idToString() + ", " + this.getConnector() + ", " + this.endToString() + "]";
    }
}

