/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.plug;

import alma.acs.util.ACSPorts;
import alma.acsdaemon.ContainerDaemon;
import alma.acsdaemon.ContainerDaemonHelper;
import alma.acsdaemon.ServicesDaemon;
import alma.acsdaemon.ServicesDaemonHelper;
import com.cosylab.acs.maci.Daemon;
import com.cosylab.acs.maci.ServiceDaemon;
import com.cosylab.acs.maci.Transport;
import com.cosylab.acs.maci.plug.DaemonProxy;
import com.cosylab.acs.maci.plug.ServiceDaemonProxy;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CORBATransport
implements Transport {
    ORB orb;
    String managerIOR;

    public CORBATransport(ORB orb, String managerIOR) {
        this.orb = orb;
        this.managerIOR = managerIOR;
    }

    @Override
    public Daemon getDaemon(String host) {
        String daemonCORBALOC = "corbaloc::" + host + ":" + ACSPorts.getContainerDaemonPort() + "/ACSContainerDaemon";
        ContainerDaemon daemon = null;
        try {
            Object obj = this.orb.string_to_object(daemonCORBALOC);
            daemon = ContainerDaemonHelper.narrow((Object)obj);
            if (daemon == null) {
                throw new NullPointerException("Daemon object was null");
            }
        }
        catch (Throwable thr) {
            throw new RuntimeException("Failed to resolve daemon reference for " + daemonCORBALOC, thr);
        }
        return new DaemonProxy(daemon);
    }

    @Override
    public ServiceDaemon getServiceDaemon(String host) {
        String daemonCORBALOC = "corbaloc::" + host + ":" + ACSPorts.getServicesDaemonPort() + "/ACSServicesDaemon";
        ServicesDaemon daemon = null;
        try {
            Object obj = this.orb.string_to_object(daemonCORBALOC);
            daemon = ServicesDaemonHelper.narrow((Object)obj);
            if (daemon == null) {
                throw new NullPointerException("service daemon object was null");
            }
        }
        catch (Throwable thr) {
            throw new RuntimeException("Failed to resolve service daemon reference for " + daemonCORBALOC, thr);
        }
        return new ServiceDaemonProxy(daemon);
    }

    @Override
    public String getManagerReference() {
        return this.managerIOR;
    }
}

