/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AlmaFile {
    private String XSD;
    private String Ver;
    private File fp;
    private ZipEntry zp;
    private ZipFile zf;
    private final Type type;

    AlmaFile(File fp) {
        this.type = Type.FILE;
        this.fp = fp;
    }

    AlmaFile(ZipFile zf, ZipEntry zp) {
        this.type = Type.ZIPENTRY;
        this.zp = zp;
        this.zf = zf;
    }

    InputStream getStream() {
        InputStream is = null;
        try {
            if (this.type == Type.FILE) {
                is = new FileInputStream(this.fp);
            } else if (this.type == Type.ZIPENTRY) {
                is = this.zf.getInputStream(this.zp);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }

    long getSize() {
        return this.zp.getSize();
    }

    void setXSD(String xsd) {
        this.XSD = xsd;
    }

    void setVer(String ver) {
        this.Ver = ver;
    }

    String getXSD() {
        return this.XSD;
    }

    String getVer() {
        return this.Ver;
    }

    public static enum Type {
        FILE,
        ZIPENTRY;

    }
}

