/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics.gui;

import diva.canvas.AbstractFigure;
import diva.canvas.Figure;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.LabelFigure;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import jsky.graphics.CanvasFigure;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.graphics.RoiFigure;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.util.I18N;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;

public class CanvasDraw
implements MouseInputListener {
    private static final I18N _I18N = I18N.getInstance(CanvasDraw.class);
    public static final int SELECT = 0;
    public static final int REGION = 1;
    public static final int LINE = 2;
    public static final int RECTANGLE = 3;
    public static final int ELLIPSE = 4;
    public static final int POLYLINE = 5;
    public static final int POLYGON = 6;
    public static final int FREEHAND = 7;
    public static final int TEXT = 8;
    public static final String[] DRAWING_MODES = new String[]{"select", "region", "line", "rectangle", "ellipse", "polyline", "polygon", "freehand", "text"};
    public static final int NUM_DRAWING_MODES = DRAWING_MODES.length;
    public static final Color[] COLORS = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow, null};
    public static final String[] COLOR_NAMES = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow", null};
    public static final int NUM_COLORS = COLORS.length;
    public static final Composite[] COMPOSITES = new Composite[]{AlphaComposite.getInstance(3, 0.0f), AlphaComposite.getInstance(3, 0.1f), AlphaComposite.getInstance(3, 0.2f), AlphaComposite.getInstance(3, 0.3f), AlphaComposite.getInstance(3, 0.4f), AlphaComposite.getInstance(3, 0.5f), AlphaComposite.getInstance(3, 0.6f), AlphaComposite.getInstance(3, 0.7f), AlphaComposite.getInstance(3, 0.8f), AlphaComposite.getInstance(3, 0.9f), AlphaComposite.SrcOver};
    public static final String[] COMPOSITE_NAMES = new String[]{"0%", "10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"};
    public static final int NUM_COMPOSITES = COMPOSITES.length;
    public static final Font[] FONTS = new Font[]{new Font("Dialog", 0, 12), new Font("Dialog", 2, 12), new Font("Dialog", 1, 12), new Font("Dialog", 0, 14), new Font("Dialog", 2, 14), new Font("Dialog", 1, 14), new Font("Dialog", 0, 18), new Font("Dialog", 2, 18), new Font("Dialog", 1, 18), new Font("Dialog", 0, 24), new Font("Dialog", 2, 24), new Font("Dialog", 1, 24)};
    public static final int NUM_FONTS = FONTS.length;
    public static final int[] LINE_WIDTHS = new int[]{1, 2, 3, 4};
    public static final int NUM_LINE_WIDTHS = LINE_WIDTHS.length;
    protected DivaMainImageDisplay imageDisplay;
    protected DivaImageGraphics graphics;
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected boolean mouseClicked = false;
    protected int startX;
    protected int startY;
    protected Polyline2D.Double polyline;
    protected Polygon2D.Double polygon;
    protected Polyline2D.Double freehand;
    protected AbstractFigure figure;
    protected List<Figure> figureList = new LinkedList<Figure>();
    protected AbstractAction[] drawingModeActions = new AbstractAction[NUM_DRAWING_MODES];
    protected int drawingMode = 0;
    protected boolean visible = true;
    protected Paint fill = null;
    protected Paint outline = Color.white;
    protected AbstractAction[] outlineActions = new AbstractAction[NUM_COLORS];
    protected AbstractAction[] fillActions = new AbstractAction[NUM_COLORS];
    protected AbstractAction[] compositeActions = new AbstractAction[NUM_COMPOSITES];
    protected Composite composite = AlphaComposite.SrcOver;
    protected AbstractAction[] fontActions = new AbstractAction[NUM_FONTS];
    protected Font font = FONTS[3];
    protected int lineWidth = 1;
    protected AbstractAction[] lineWidthActions = new AbstractAction[NUM_LINE_WIDTHS];
    protected AbstractAction deleteSelectedAction = new AbstractAction(_I18N.getString("deleteSelected")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.deleteSelected();
        }
    };
    protected AbstractAction clearAction = new AbstractAction(_I18N.getString("clear")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.clear();
        }
    };
    protected AbstractAction hideGraphicsAction = new AbstractAction(_I18N.getString("hideGraphics")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.hideGraphics();
        }
    };

    public CanvasDraw(DivaMainImageDisplay imageDisplay) {
        int i;
        this.imageDisplay = imageDisplay;
        this.graphics = (DivaImageGraphics)imageDisplay.getCanvasGraphics();
        imageDisplay.addMouseListener(this);
        imageDisplay.addMouseMotionListener(this);
        for (i = 0; i < NUM_DRAWING_MODES; ++i) {
            this.drawingModeActions[i] = new DrawingModeAction(i);
        }
        for (i = 0; i < NUM_LINE_WIDTHS; ++i) {
            this.lineWidthActions[i] = new LineWidthAction(i);
        }
        for (i = 0; i < NUM_COLORS; ++i) {
            this.outlineActions[i] = new OutlineAction(COLORS[i]);
        }
        for (i = 0; i < NUM_COLORS; ++i) {
            this.fillActions[i] = new FillAction(COLORS[i]);
        }
        for (i = 0; i < NUM_COMPOSITES; ++i) {
            this.compositeActions[i] = new CompositeAction(COMPOSITE_NAMES[i], COMPOSITES[i]);
        }
        for (i = 0; i < NUM_FONTS; ++i) {
            this.fontActions[i] = new FontAction(FONTS[i]);
        }
    }

    public DivaMainImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    public void setDrawingMode(int drawingMode) {
        this.drawingMode = drawingMode;
        if (drawingMode == 1) {
            this.graphics.getSelectionDragger().setEnabled(true);
        }
        this.fireChange();
    }

    public int getDrawingMode() {
        return this.drawingMode;
    }

    public AbstractAction getDrawingModeAction(int drawingMode) {
        return this.drawingModeActions[drawingMode];
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        for (CanvasFigure fig : this.graphics.getSelectedFigures()) {
            if (!(fig instanceof BasicFigure)) continue;
            ((BasicFigure)((Object)fig)).setLineWidth(lineWidth);
        }
        this.fireChange();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public AbstractAction getLineWidthAction(int i) {
        return this.lineWidthActions[i];
    }

    public void setOutline(Paint outline) {
        this.outline = outline;
        for (CanvasFigure fig : this.graphics.getSelectedFigures()) {
            if (!(fig instanceof BasicFigure)) continue;
            ((BasicFigure)((Object)fig)).setStrokePaint(outline);
        }
        this.fireChange();
    }

    public Paint getOutline() {
        return this.outline;
    }

    public AbstractAction getOutlineAction(int i) {
        return this.outlineActions[i];
    }

    public void setFill(Paint fill) {
        this.fill = fill;
        for (CanvasFigure fig : this.graphics.getSelectedFigures()) {
            if (fig instanceof BasicFigure) {
                ((BasicFigure)((Object)fig)).setFillPaint(fill);
                continue;
            }
            if (!(fig instanceof LabelFigure)) continue;
            ((LabelFigure)((Object)fig)).setFillPaint(fill);
        }
        this.fireChange();
    }

    public Paint getFill() {
        return this.fill;
    }

    public AbstractAction getFillAction(int i) {
        return this.fillActions[i];
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
        for (CanvasFigure fig : this.graphics.getSelectedFigures()) {
            if (!(fig instanceof BasicFigure)) continue;
            ((BasicFigure)((Object)fig)).setComposite((AlphaComposite)composite);
        }
        this.fireChange();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public AbstractAction getCompositeAction(int i) {
        return this.compositeActions[i];
    }

    public void setFont(Font font) {
        this.font = font;
        for (CanvasFigure fig : this.graphics.getSelectedFigures()) {
            if (!(fig instanceof LabelFigure)) continue;
            ((LabelFigure)((Object)fig)).setFont(font);
        }
        this.fireChange();
    }

    public Font getFont() {
        return this.font;
    }

    public AbstractAction getFontAction(int i) {
        return this.fontActions[i];
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChange() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int count = e.getClickCount();
        SelectionInteractor si = this.graphics.getRoiSelectionInteractor();
        if (this.mouseClicked) {
            if (this.drawingMode == 5) {
                if (count == 1) {
                    if (this.figure.getShape() instanceof Polyline2D.Double) {
                        this.polyline = (Polyline2D.Double)this.figure.getShape();
                    }
                    return;
                }
                if (count > 1) {
                    this.figure.setInteractor(si);
                }
            } else if (this.drawingMode == 6) {
                if (count == 1) {
                    if (this.figure.getShape() instanceof Polygon2D.Double) {
                        this.polygon = (Polygon2D.Double)this.figure.getShape();
                    }
                    return;
                }
                if (count > 1) {
                    this.figure.setInteractor(si);
                }
            } else if (this.drawingMode == 7) {
                if (count == 1) {
                    if (this.figure.getShape() instanceof Polyline2D.Double) {
                        this.freehand = (Polyline2D.Double)this.figure.getShape();
                    }
                    return;
                }
                if (count > 1) {
                    this.figure.setInteractor(si);
                }
            }
            this.finishFigure();
        } else {
            this.mouseClicked = true;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.drawingMode == 5 && this.polyline != null || this.drawingMode == 6 && this.polygon != null || this.drawingMode == 7 && this.freehand != null) {
            return;
        }
        this.startX = e.getX();
        this.startY = e.getY();
        SelectionInteractor interactor = this.graphics.getRoiSelectionInteractor();
        Shape shape = null;
        this.figure = null;
        switch (this.drawingMode) {
            case 2: {
                shape = new Polyline2D.Double(this.startX, this.startY, this.startX + 1, this.startY + 1);
                interactor = this.graphics.getLineInteractor();
                break;
            }
            case 3: {
                shape = new Rectangle2D.Double(this.startX, this.startY, 1.0, 1.0);
                break;
            }
            case 4: {
                shape = new Ellipse2D.Double(this.startX, this.startY, 1.0, 1.0);
                break;
            }
            case 5: {
                this.polyline = new Polyline2D.Double();
                this.polyline.moveTo(this.startX, this.startY);
                shape = this.polyline;
                interactor = null;
                break;
            }
            case 6: {
                this.polygon = new Polygon2D.Double();
                this.polygon.moveTo(this.startX, this.startY);
                shape = this.polygon;
                interactor = null;
                break;
            }
            case 7: {
                this.freehand = new Polyline2D.Double();
                this.freehand.moveTo(this.startX, this.startY);
                shape = this.freehand;
                break;
            }
            case 8: {
                return;
            }
        }
        if (shape != null) {
            this.figure = (AbstractFigure)((Object)this.graphics.makeFigure(shape, this.fill, this.outline, this.lineWidth, this.composite, interactor));
            this.graphics.add((CanvasFigure)((Object)this.figure));
            this.figureList.add(this.figure);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        switch (this.drawingMode) {
            case 5: {
                if (this.polyline != null) {
                    if (!(this.figure.getShape() instanceof Polyline2D.Double)) break;
                    this.polyline = (Polyline2D.Double)this.figure.getShape();
                    break;
                }
                if (this.startX == e.getX() && this.startY == e.getY()) break;
                this.finishFigure();
                break;
            }
            case 6: {
                if (this.polygon != null) {
                    if (!(this.figure.getShape() instanceof Polygon2D.Double)) break;
                    this.polygon = (Polygon2D.Double)this.figure.getShape();
                    break;
                }
                if (this.startX == e.getX() && this.startY == e.getY()) break;
                this.finishFigure();
                break;
            }
            case 8: {
                Point2D.Double pos = new Point2D.Double(this.startX, this.startY);
                String s = DialogUtil.input(_I18N.getString("pleaseEnterLabelText"));
                if (s == null || s.length() == 0) break;
                this.figure = (AbstractFigure)((Object)this.graphics.makeLabel(pos, 1, s, this.outline, this.font, this.graphics.getSelectionInteractor()));
                this.addFigure((CanvasFigure)((Object)this.figure));
                this.finishFigure();
                return;
            }
            default: {
                if (this.startX == e.getX() && this.startY == e.getY()) break;
                this.finishFigure();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.figure != null) {
            int endX = e.getX();
            int endY = e.getY();
            Shape shape = null;
            switch (this.drawingMode) {
                case 2: {
                    shape = new Polyline2D.Double(this.startX, this.startY, endX, endY);
                    break;
                }
                case 3: {
                    shape = new Rectangle2D.Double(this.startX, this.startY, endX - this.startX, endY - this.startY);
                    break;
                }
                case 4: {
                    shape = new Ellipse2D.Double(this.startX, this.startY, endX - this.startX, endY - this.startY);
                    break;
                }
                case 5: {
                    int n = this.polyline.getVertexCount();
                    Polyline2D.Double pl = new Polyline2D.Double();
                    pl.moveTo(this.polyline.getX(0), this.polyline.getY(0));
                    for (int i = 1; i < n; ++i) {
                        pl.lineTo(this.polyline.getX(i), this.polyline.getY(i));
                    }
                    pl.lineTo(endX, endY);
                    shape = pl;
                    break;
                }
                case 6: {
                    int n = this.polygon.getVertexCount();
                    Polygon2D.Double pg = new Polygon2D.Double();
                    pg.moveTo(this.polygon.getX(0), this.polygon.getY(0));
                    for (int i = 1; i < n; ++i) {
                        pg.lineTo(this.polygon.getX(i), this.polygon.getY(i));
                    }
                    pg.lineTo(endX, endY);
                    shape = pg;
                    break;
                }
                case 7: {
                    this.freehand.lineTo(endX, endY);
                    shape = this.freehand;
                    break;
                }
                case 8: {
                    return;
                }
            }
            if (shape != null) {
                ((BasicFigure)this.figure).setShape(shape);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseDragged(e);
    }

    protected void finishFigure() {
        if (this.figure != null) {
            this.graphics.clearSelection();
            if (this.figure instanceof RoiFigure) {
                ((RoiFigure)this.figure).updateGeometry();
            }
            this.graphics.select((CanvasFigure)((Object)this.figure));
            this.figure = null;
        }
        this.polyline = null;
        this.polygon = null;
        this.freehand = null;
        this.setDrawingMode(0);
        this.mouseClicked = false;
    }

    public void clear() {
        ListIterator<Figure> it = this.figureList.listIterator(0);
        while (it.hasNext()) {
            CanvasFigure fig = (CanvasFigure)it.next();
            if (fig.isPersistent()) continue;
            this.graphics.remove(fig);
            it.remove();
        }
    }

    public void deleteSelected() {
        for (CanvasFigure fig : this.graphics.getSelectedFigures()) {
            this.graphics.remove(fig);
        }
    }

    public void hideGraphics() {
        this.visible = !this.visible;
        ListIterator<Figure> it = this.figureList.listIterator(0);
        while (it.hasNext()) {
            CanvasFigure fig = (CanvasFigure)it.next();
            fig.setVisible(this.visible);
        }
    }

    public List<Figure> getFigureList() {
        return this.figureList;
    }

    public void addFigure(CanvasFigure fig) {
        this.figureList.add(fig);
        this.graphics.add(fig);
    }

    private static String getFontDisplayName(Font font) {
        String family = font.getFamily();
        String style = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
        return family + "-" + style + "-" + font.getSize();
    }

    class FontAction
    extends AbstractAction {
        Font font;

        public FontAction(Font font) {
            super(CanvasDraw.getFontDisplayName(font));
            this.font = font;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.setFont(this.font);
        }
    }

    class CompositeAction
    extends AbstractAction {
        Composite composite;

        public CompositeAction(String label, Composite composite) {
            super(label);
            this.composite = composite;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.setComposite(this.composite);
        }
    }

    class FillAction
    extends AbstractAction {
        Paint color;

        public FillAction(Paint color) {
            super(color != null ? "    " : _I18N.getString("none"));
            this.color = color;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.setFill(this.color);
        }
    }

    class OutlineAction
    extends AbstractAction {
        Paint color;

        public OutlineAction(Paint color) {
            super(color != null ? "    " : _I18N.getString("none"));
            this.color = color;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.setOutline(this.color);
        }
    }

    class LineWidthAction
    extends GraphicsAction {
        int width;

        public LineWidthAction(int i) {
            super(i + 1 + " pixel" + (i > 0 ? "s" : ""), "width" + (i + 1));
            this.width = i + 1;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.setLineWidth(this.width);
        }
    }

    class DrawingModeAction
    extends GraphicsAction {
        int drawingMode;

        public DrawingModeAction(int drawingMode) {
            super(DRAWING_MODES[drawingMode], DRAWING_MODES[drawingMode]);
            this.drawingMode = drawingMode;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CanvasDraw.this.setDrawingMode(this.drawingMode);
        }
    }

    abstract class GraphicsAction
    extends AbstractAction {
        String name;

        public GraphicsAction(String title, String name) {
            super(title, Resources.getIcon(name + ".gif"));
            this.name = name;
        }
    }
}

