/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.util.gui.SelectCharactersEvent;
import uk.ac.starlink.util.gui.SelectCharactersListener;
import uk.ac.starlink.util.gui.SelectCharactersModel;
import uk.ac.starlink.util.images.ImageHolder;

public class SelectCharacters
extends JDialog {
    private Font displayFont = null;
    JPanel contentPane = null;
    JMenuBar menuBar = new JMenuBar();
    JMenu menuFile = new JMenu();
    JMenuItem menuFileCancel = new JMenuItem();
    JMenu menuHelp = new JMenu();
    JPanel actionBar = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    JTable table = new JTable();
    JTextField text = new JTextField();
    SelectCharactersModel model = null;
    protected EventListenerList listeners = new EventListenerList();

    public SelectCharacters(Font displayFont) {
        this(null, "Select Characters", false, displayFont);
    }

    public SelectCharacters(Frame owner, String title, boolean modal, Font displayFont) {
        super(owner, title, modal);
        try {
            this.initUI();
            this.setDisplayFont(displayFont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enableEvents(64L);
    }

    public void setDisplayFont(Font displayFont) {
        this.displayFont = displayFont;
        this.initFont();
    }

    private void initUI() throws Exception {
        ImageIcon acceptimage = new ImageIcon(ImageHolder.class.getResource("accept.gif"));
        ImageIcon cancelimage = new ImageIcon(ImageHolder.class.getResource("exit.gif"));
        ImageIcon helpimage = new ImageIcon(ImageHolder.class.getResource("help.gif"));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.setSize(new Dimension(400, 300));
        this.table.setToolTipText("Select a character");
        this.table.setTableHeader(null);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        ListSelectionModel listModel = this.table.getSelectionModel();
        listModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SelectCharacters.this.cellSelected(e);
            }
        });
        this.setJMenuBar(this.menuBar);
        this.menuFile.setText("File");
        this.menuBar.add(this.menuFile);
        this.text.setToolTipText("Editable list of selected characters");
        this.actionBar.setLayout(new BoxLayout(this.actionBar, 0));
        this.actionBar.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        AcceptAction acceptAction = new AcceptAction("Accept", acceptimage);
        this.menuFile.add(acceptAction);
        JButton acceptButton = new JButton(acceptAction);
        this.actionBar.add(Box.createGlue());
        this.actionBar.add(acceptButton);
        acceptButton.setToolTipText("Accept the selected characters and close window");
        CancelAction cancelAction = new CancelAction("Cancel", cancelimage);
        this.menuFile.add(cancelAction);
        JButton cancelButton = new JButton(cancelAction);
        this.actionBar.add(Box.createGlue());
        this.actionBar.add(cancelButton);
        cancelButton.setToolTipText("Close window, cancelling selected characters");
        this.actionBar.add(Box.createGlue());
        this.contentPane.add((Component)this.scrollPane, "Center");
        JPanel actions = new JPanel(new BorderLayout());
        this.contentPane.add((Component)actions, "South");
        this.scrollPane.getViewport().add((Component)this.table, null);
        actions.add((Component)this.actionBar, "South");
        actions.add((Component)this.text, "North");
    }

    protected void closeWindowEvent(boolean accept) {
        if (accept) {
            this.fireExiting();
        }
        this.dispose();
    }

    protected void initFont() {
        this.model = new SelectCharactersModel(this.displayFont);
        this.table.setModel(this.model);
        this.table.setFont(this.displayFont.deriveFont(12.0f));
        this.text.setFont(this.displayFont);
    }

    protected void cellSelected(ListSelectionEvent e) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        this.text.replaceSelection((String)this.model.getValueAt(row, col));
        this.table.clearSelection();
    }

    public void addListener(SelectCharactersListener l) {
        this.listeners.add(SelectCharactersListener.class, l);
    }

    protected void fireExiting() {
        Object[] la = this.listeners.getListenerList();
        SelectCharactersEvent e = null;
        for (int i = la.length - 2; i >= 0; i -= 2) {
            if (la[i] != (class$uk$ac$starlink$util$gui$SelectCharactersListener == null ? SelectCharacters.class$("uk.ac.starlink.util.gui.SelectCharactersListener") : class$uk$ac$starlink$util$gui$SelectCharactersListener)) continue;
            if (e == null) {
                e = new SelectCharactersEvent(this, this.text.getText());
            }
            ((SelectCharactersListener)la[i + 1]).newCharacters(e);
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            SelectCharacters.this.closeWindowEvent(false);
        }
    }

    protected class AcceptAction
    extends AbstractAction {
        public AcceptAction(String name, Icon icon) {
            super(name, icon);
        }

        public void actionPerformed(ActionEvent ae) {
            SelectCharacters.this.closeWindowEvent(true);
        }
    }
}

