/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;

public class ColumnQueryRowSequence
extends WrapperRowSequence
implements ConeQueryRowSequence {
    private final int raCol_;
    private final int decCol_;
    private final int srCol_;

    public ColumnQueryRowSequence(StarTable table, int raCol, int decCol, int srCol) throws IOException {
        super(table.getRowSequence());
        this.raCol_ = raCol;
        this.decCol_ = decCol;
        this.srCol_ = srCol;
    }

    public double getRa() throws IOException {
        return this.getDoubleCell(this.raCol_);
    }

    public double getDec() throws IOException {
        return this.getDoubleCell(this.decCol_);
    }

    public double getRadius() throws IOException {
        return this.getDoubleCell(this.srCol_);
    }

    private double getDoubleCell(int colIndex) throws IOException {
        Object value = this.getCell(colIndex);
        return value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
    }

    public static ConeQueryRowSequence createFixedRadiusSequence(StarTable table, int raCol, int decCol, final double sr) throws IOException {
        return new ColumnQueryRowSequence(table, raCol, decCol, -1){

            public double getRadius() {
                return sr;
            }
        };
    }
}

