/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.MarkStyles;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plottask.ColorParameter;
import uk.ac.starlink.ttools.plottask.StyleFactory;
import uk.ac.starlink.ttools.plottask.StyleParameter;

public class MarkStyleFactory
extends StyleFactory {
    private final int errNdim_;
    private final StyleSet styleSet_ = MarkStyles.spots("Spots", 2);
    private static final MarkShape[] SHAPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MarkStyleFactory(String prefix, int errNdim) {
        super(prefix);
        this.errNdim_ = errNdim;
    }

    public Parameter[] getParameters(String stSuffix) {
        ArrayList<ColorParameter> paramList = new ArrayList<ColorParameter>();
        paramList.add(this.createColorParameter(stSuffix));
        paramList.add((ColorParameter)this.createShapeParameter(stSuffix));
        paramList.add((ColorParameter)this.createSizeParameter(stSuffix));
        paramList.add((ColorParameter)this.createTransparencyParameter(stSuffix));
        paramList.add((ColorParameter)this.createLineParameter(stSuffix));
        paramList.add((ColorParameter)this.createHidePointsParameter(stSuffix));
        if (this.errNdim_ > 0) {
            paramList.add((ColorParameter)this.createErrorRendererParameter(stSuffix));
        }
        return paramList.toArray(new Parameter[0]);
    }

    public Style getStyle(Environment env, String stSuffix) throws TaskException {
        MarkStyle style0 = (MarkStyle)this.styleSet_.getStyle(this.getStyleIndex(stSuffix));
        ChoiceParameter shapeParam = this.createShapeParameter(stSuffix);
        shapeParam.setDefaultOption((Object)style0.getShapeId());
        MarkShape shape = (MarkShape)shapeParam.objectValue(env);
        ColorParameter colorParam = this.createColorParameter(stSuffix);
        colorParam.setDefaultColor(style0.getColor());
        Color color = colorParam.colorValue(env);
        IntegerParameter sizeParam = this.createSizeParameter(stSuffix);
        int size = sizeParam.intValue(env);
        MarkStyle style = shape.getStyle(color, size);
        IntegerParameter transparParam = this.createTransparencyParameter(stSuffix);
        transparParam.setDefault(Integer.toString(style0.getOpaqueLimit()));
        style.setOpaqueLimit(transparParam.intValue(env));
        ChoiceParameter lineParam = this.createLineParameter(stSuffix);
        lineParam.setDefaultOption((Object)style0.getLine());
        style.setLine((MarkStyle.Line)lineParam.objectValue(env));
        BooleanParameter hideParam = this.createHidePointsParameter(stSuffix);
        hideParam.setDefault(style0.getHidePoints() ? "true" : "false");
        style.setHidePoints(hideParam.booleanValue(env));
        if (this.errNdim_ > 0) {
            ChoiceParameter errParam = this.createErrorRendererParameter(stSuffix);
            errParam.setDefaultOption((Object)style.getErrorRenderer());
            ErrorRenderer errRend = (ErrorRenderer)errParam.objectValue(env);
            style.setErrorRenderer(errRend == null ? ErrorRenderer.NONE : errRend);
        }
        return style;
    }

    private ColorParameter createColorParameter(String stSuffix) {
        ColorParameter param = new ColorParameter(this.paramName("colour", stSuffix));
        param.setPrompt("Marker colour for data set " + stSuffix);
        param.setDescription(new String[]{"<p>Defines the colour of markers plotted.", param.getFormatDescription(), "</p>", "<p>For most purposes, either the American or the British spelling", "is accepted for this parameter name.", "</p>"});
        return param;
    }

    private IntegerParameter createSizeParameter(String stSuffix) {
        IntegerParameter param = new IntegerParameter(this.paramName("size", stSuffix));
        param.setPrompt("Marker size in pixels for data set " + stSuffix);
        param.setDefault(Integer.toString(-1));
        param.setDescription(new String[]{"<p>Defines the marker size in pixels for markers plotted in", "data set " + stSuffix + ".", "If the value is negative, an attempt will be made to use a", "suitable size according to how many points there are to be", "plotted.", "</p>"});
        return param;
    }

    private ChoiceParameter createShapeParameter(String stSuffix) {
        StyleParameter param = new StyleParameter(this.paramName("shape", stSuffix), SHAPES);
        param.setPrompt("Marker shape for data set " + stSuffix);
        param.setDescription(new String[]{"<p>Defines the shapes for the markers that are plotted in", "data set " + stSuffix + ".", "The following shapes are available:", param.getOptionList(), "</p>"});
        return param;
    }

    private ChoiceParameter createErrorRendererParameter(String stSuffix) {
        Object[] options = this.errNdim_ == 2 ? ErrorRenderer.getOptions2d() : (this.errNdim_ == 3 ? ErrorRenderer.getOptions3d() : ErrorRenderer.getOptionsGeneral());
        StyleParameter param = new StyleParameter(this.paramName("errstyle", stSuffix), options);
        param.setPrompt("Error bar style for data set " + stSuffix);
        param.setDescription(new String[]{"<p>Defines the way in which error bars (or ellipses, or...)", "will be represented for data set " + stSuffix, "if errors are being displayed.", "The following options are available:", param.getOptionList(), "</p>"});
        param.setNullPermitted(true);
        if (Arrays.asList(options).contains(ErrorRenderer.DEFAULT) && Arrays.asList(options).contains(ErrorRenderer.EXAMPLE)) {
            param.setUsage(param.getName(ErrorRenderer.DEFAULT) + "|" + param.getName(ErrorRenderer.EXAMPLE) + "|" + "...");
            param.setDefaultOption(ErrorRenderer.DEFAULT);
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            param.setDefaultOption(options[1]);
        }
        return param;
    }

    private IntegerParameter createTransparencyParameter(String stSuffix) {
        IntegerParameter param = new IntegerParameter(this.paramName("transparency", stSuffix));
        param.setMinimum(1);
        param.setPrompt("Transparency for markers plotted for data set " + stSuffix);
        param.setDescription(new String[]{"<p>Determines the transparency of plotted markers", "for data set " + stSuffix + ".", "A value of <code>&lt;n&gt;</code> means that opacity is only", "achieved (the background is only blotted out)", "when <code>&lt;n&gt;</code> pixels of this colour have been", "plotted on top of each other.", "</p>", "<p>The minimum value is 1, which means opaque markers.", "</p>"});
        return param;
    }

    private ChoiceParameter createLineParameter(String stSuffix) {
        ChoiceParameter param = new ChoiceParameter(this.paramName("line", stSuffix), (Object[])new MarkStyle.Line[]{MarkStyle.DOT_TO_DOT, MarkStyle.LINEAR});
        param.setNullPermitted(true);
        param.setPrompt("Type of line, if any, to plot for data set " + stSuffix);
        param.setDescription(new String[]{"<p>Determines what line if any will be plotted along with the", "data points.", "The options are:", "<ul>", "<li><code>null</code>:", "No line is plotted.</li>", "<li><code>" + MarkStyle.DOT_TO_DOT.toString() + "</code>:", "Each point is joined to the next one in sequence", "by a straight line.</li>", "<li><code>" + MarkStyle.LINEAR.toString() + "</code>:", "A linear regression line is plotted based on all the points", "which are visible in the plot.", "Note that the regression coefficients take no account of", "points out of the visible range.</li>", "</ul>", "</p>"});
        return param;
    }

    private BooleanParameter createHidePointsParameter(String stSuffix) {
        BooleanParameter param = new BooleanParameter(this.paramName("hide", stSuffix));
        param.setDefault("false");
        param.setPrompt("Hide point markers for data set " + stSuffix + "?");
        param.setDescription(new String[]{"<p>Indicates whether the actual markers plotted for each point", "should be hidden.", "Normally this is false, but you may want to set it to true", "if the point positions are being revealed in some other way,", "for instance by error markers or lines drawn between them.", "</p>"});
        return param;
    }

    static {
        $assertionsDisabled = !MarkStyleFactory.class.desiredAssertionStatus();
        SHAPES = new MarkShape[]{MarkShape.FILLED_CIRCLE, MarkShape.OPEN_CIRCLE, MarkShape.CROSS, MarkShape.CROXX, MarkShape.OPEN_SQUARE, MarkShape.OPEN_DIAMOND, MarkShape.OPEN_TRIANGLE_UP, MarkShape.OPEN_TRIANGLE_DOWN, MarkShape.FILLED_SQUARE, MarkShape.FILLED_DIAMOND, MarkShape.FILLED_TRIANGLE_UP, MarkShape.FILLED_TRIANGLE_DOWN};
    }
}

