/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.Plot3D;
import uk.ac.starlink.ttools.plot.Plot3DState;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plottask.PlotStateFactory;

public class Plot3DStateFactory
extends PlotStateFactory {
    private final DoubleParameter fogParam_ = new DoubleParameter("fog");
    private final DoubleParameter phiParam_;
    private final DoubleParameter thetaParam_;

    public Plot3DStateFactory(String[] dimNames, boolean useAux, boolean useLabel, int errNdim) {
        super(dimNames, useAux, useLabel, errNdim);
        this.fogParam_.setPrompt("Depth fog level");
        this.fogParam_.setNullPermitted(false);
        this.fogParam_.setMinimum(0.0, true);
        this.fogParam_.setDescription(new String[]{"<p>Sets the level of fogging used to provide a visual", "indication of depth.", "Object plotted further away from the viewer appear more", "washed-out by a white fog.", "The default value gives a bit of fogging; increase it to", "make the fog thicker, or set to zero if no fogging is required.", "</p>"});
        this.fogParam_.setDefault(new Double(1.0).toString());
        this.phiParam_ = new DoubleParameter("phi");
        this.phiParam_.setPrompt("Rotation around Z axis");
        this.phiParam_.setNullPermitted(false);
        this.phiParam_.setDescription(new String[]{"<p>Angle in degrees through which the 3D plot is rotated", "abound the Z axis prior to drawing.", "</p>"});
        this.phiParam_.setDefault(new Double(30.0).toString());
        this.thetaParam_ = new DoubleParameter("theta");
        this.thetaParam_.setPrompt("Rotation around plane horizontal");
        this.thetaParam_.setNullPermitted(false);
        this.thetaParam_.setDescription(new String[]{"<p>Angle in degrees through which the 3D plot is rotated", "towards the viewer", "(i.e. about the horizontal axis of the viewing plane)", "prior to drawing.", "</p>"});
        this.thetaParam_.setDefault(new Double(15.0).toString());
    }

    public Parameter[] getParameters() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.addAll(Arrays.asList(super.getParameters()));
        paramList.add(this.fogParam_);
        paramList.add(this.phiParam_);
        paramList.add(this.thetaParam_);
        return paramList.toArray(new Parameter[0]);
    }

    protected PlotState createPlotState() {
        return new Plot3DState();
    }

    protected void configurePlotState(PlotState state, Environment env) throws TaskException {
        super.configurePlotState(state, env);
        Plot3DState state3 = (Plot3DState)state;
        state3.setRotating(false);
        state3.setZoomScale(1.0);
        state3.setFogginess(this.fogParam_.doubleValue(env));
        double[] matrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0};
        double theta = this.thetaParam_.doubleValue(env);
        double phi = this.phiParam_.doubleValue(env);
        matrix = Plot3D.rotateXY(matrix, 0.0, 1.5707963267948966);
        matrix = Plot3D.rotateXY(matrix, Math.toRadians(phi), 0.0);
        matrix = Plot3D.rotateXY(matrix, 0.0, -Math.toRadians(theta));
        state3.setRotation(matrix);
    }
}

