/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.CopyMode;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.TableConsumerParameter;

public class OutputTableParameter
extends Parameter
implements TableConsumerParameter {
    private final OutputFormatParameter formatParam_ = new OutputFormatParameter("ofmt");
    private TableConsumer consumer_;

    public OutputTableParameter(String name) {
        super(name);
        this.setUsage("<out-table>");
        this.setPrompt("Location of output table");
        this.setDefault("-");
        this.setDescription(new String[]{"<p>The location of the output table.  This is usually a filename", "to write to.", "If it is equal to the special value \"-\" (the default)", "the output table will be written to standard output.", "</p>"});
    }

    public OutputFormatParameter getFormatParameter() {
        return this.formatParam_;
    }

    public void setValueFromConsumer(TableConsumer consumer) {
        this.consumer_ = consumer;
        this.setStringValue(consumer.toString());
        this.setGotValue(true);
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        if (sval != null) {
            String loc = sval;
            String fmt = this.formatParam_.stringValue(env);
            this.consumer_ = CopyMode.createConsumer(env, loc, fmt);
        }
        super.setValueFromString(env, sval);
    }

    public TableConsumer consumerValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.consumer_;
    }
}

