/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.MessageInputStream;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.RemarshalException;

public abstract class ReplyPlaceholder {
    protected final Object lock = new Object();
    protected boolean ready = false;
    protected boolean communicationException = false;
    protected boolean remarshalException = false;
    protected boolean timeoutException = false;
    protected Throwable exceptionCause = null;
    protected MessageInputStream in = null;
    protected int timeout;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.pending_reply_timeout", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(MessageInputStream in) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.timeoutException) {
                this.in = in;
                this.ready = true;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Throwable exceptionCause) {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                this.communicationException = true;
                this.ready = true;
                this.lock.notify();
                this.exceptionCause = exceptionCause;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retry() {
        Object object = this.lock;
        synchronized (object) {
            this.remarshalException = true;
            this.ready = true;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInputStream getInputStream(boolean hasTimeoutPolicy) throws RemarshalException {
        boolean _shouldUseTimeout = !hasTimeoutPolicy && this.timeout > 0;
        long _maxWait = _shouldUseTimeout ? System.currentTimeMillis() + (long)this.timeout : Long.MAX_VALUE;
        long _timeout = _shouldUseTimeout ? (long)this.timeout : 0L;
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready && System.currentTimeMillis() < _maxWait) {
                try {
                    this.lock.wait(_timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.ready && _shouldUseTimeout) {
                this.timeoutException = true;
            }
            if (this.remarshalException) {
                throw new RemarshalException();
            }
            if (this.communicationException) {
                throw SystemExceptionHelper.embedCause(new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE), this.exceptionCause);
            }
            if (this.timeoutException) {
                throw new TIMEOUT("client timeout reached");
            }
            return this.in;
        }
    }
}

