/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.image.graphics;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import diva.canvas.Site;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import jsky.image.graphics.RectangleGeometry;

public class AlmaRectangleGeometry
extends RectangleGeometry {
    private Figure _parentFigure;
    private double _minSize = 10.0;
    private double _xOvershoot = 0.0;
    private double _yOvershoot = 0.0;
    private RectangularShape _rect;
    private Shape _path;
    private static int _siteCount = 5;
    private AlmaRectangleSite[] _sites = new AlmaRectangleSite[_siteCount];
    private double _rotateAngle = 0.0;
    private Point2D _rotateCenter;
    boolean autoRefresh = true;

    public AlmaRectangleGeometry(Figure figure, Shape shape) {
        super(figure, shape);
        this._parentFigure = figure;
        this.setShape(shape);
    }

    public Site getSite(int n) {
        if (this._sites[n] == null) {
            this._sites[n] = new AlmaRectangleSite(n);
        }
        return this._sites[n];
    }

    public double getMinimumSize() {
        return this._minSize;
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public Shape getShape() {
        return this._path;
    }

    public double getRotateAngle() {
        return this._rotateAngle;
    }

    public void setRotateAngle(double d) {
        this._rotateAngle = d;
    }

    public double getNormalizedRotateAngle() {
        double d = this.getRotateAngle() + Math.PI;
        double d2 = d - Math.floor(d / (Math.PI * 2)) * (Math.PI * 2);
        return d2 - Math.PI;
    }

    public RectangularShape getRect() {
        return this._rect;
    }

    public void setMinimumSize(double d) {
        this._minSize = d;
    }

    public void setShape(Shape shape) {
        super.setShape(shape);
        this._rect = shape.getBounds2D();
        this._path = this._rect;
        this._setRotateCenter(new Point2D.Double(this._rect.getCenterX(), this._rect.getCenterY()));
    }

    public void refresh(Figure figure) {
        Cloneable cloneable;
        if (this._path instanceof RectangularShape) {
            cloneable = new AffineTransform();
            this._path = ((AffineTransform)cloneable).createTransformedShape(this._path);
        }
        if (this._path instanceof Path2D) {
            cloneable = (Path2D)this._path;
            double[] dArray = this.calcGeom((Path2D)cloneable);
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            double d4 = dArray[3];
            double d5 = this.calcAngle((Path2D)cloneable);
            if (this._rect != null && this.autoRefresh) {
                Path2D path2D = (Path2D)((Path2D)cloneable).clone();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.setToRotation(-d5, d, d2);
                path2D.transform(affineTransform);
                this._rect.setFrame(path2D.getBounds2D());
            }
            this._setRotateCenter(new Point2D.Double(d, d2));
            this.setRotateAngle(d5);
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
    }

    private Point2D.Double[] getCorners(Path2D path2D) {
        Point2D.Double[] doubleArray = new Point2D.Double[4];
        double[] dArray = new double[6];
        PathIterator pathIterator = path2D.getPathIterator(new AffineTransform());
        for (int i = 0; i < 4; ++i) {
            pathIterator.currentSegment(dArray);
            doubleArray[i] = new Point2D.Double(dArray[0], dArray[1]);
            pathIterator.next();
        }
        return doubleArray;
    }

    private double calcAngle(Path2D path2D) {
        Point2D.Double[] doubleArray = this.getCorners(path2D);
        double d = doubleArray[1].x - doubleArray[0].x;
        double d2 = doubleArray[1].y - doubleArray[0].y;
        return Math.atan2(d2, d);
    }

    private double[] calcGeom(Path2D path2D) {
        double[] dArray = new double[4];
        Point2D.Double[] doubleArray = this.getCorners(path2D);
        dArray[0] = (doubleArray[0].x + doubleArray[2].x) / 2.0;
        dArray[1] = (doubleArray[0].y + doubleArray[2].y) / 2.0;
        double d = doubleArray[1].x - doubleArray[0].x;
        double d2 = doubleArray[1].y - doubleArray[0].y;
        dArray[2] = Math.sqrt(d * d + d2 * d2);
        d = doubleArray[2].x - doubleArray[1].x;
        d2 = doubleArray[2].y - doubleArray[1].y;
        dArray[3] = Math.sqrt(d * d + d2 * d2);
        return dArray;
    }

    public Iterator sites() {
        return new Iterator(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < _siteCount;
            }

            public Object next() {
                if (AlmaRectangleGeometry.this._sites[this.cursor] == null) {
                    AlmaRectangleGeometry.this._sites[this.cursor] = new AlmaRectangleSite(this.cursor);
                }
                return AlmaRectangleGeometry.this._sites[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Site cannot be removed");
            }
        };
    }

    public void transform(AffineTransform affineTransform) {
        this._path = affineTransform.createTransformedShape(this._path);
    }

    public void translate(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        this._path = affineTransform.createTransformedShape(this._path);
        this._rect.setFrame(this._rect.getX() + d, this._rect.getY() + d2, this._rect.getWidth(), this._rect.getHeight());
        this._rotateCenter.setLocation(this._rotateCenter.getX() + d, this._rotateCenter.getY() + d2);
    }

    public Point2D getRotateCenter() {
        return this._rotateCenter;
    }

    private void _setRotateCenter(Point2D point2D) {
        this._rotateCenter = point2D;
    }

    public class AlmaRectangleSite
    extends AbstractSite {
        private int _id;
        private double _offX;
        private double _offY;

        AlmaRectangleSite(int n) {
            this._id = n;
            this.offset();
        }

        private void offset() {
            switch (this._id) {
                case 0: {
                    this._offX = AlmaRectangleGeometry.this._rect.getWidth() / 2.0;
                    this._offY = AlmaRectangleGeometry.this._rect.getHeight() / 2.0;
                    return;
                }
                case 1: {
                    this._offX = AlmaRectangleGeometry.this._rect.getWidth() / 2.0;
                    this._offY = 0.0;
                    return;
                }
                case 2: {
                    this._offX = 0.0;
                    this._offY = -AlmaRectangleGeometry.this._rect.getHeight() / 2.0;
                    return;
                }
                case 3: {
                    this._offX = -AlmaRectangleGeometry.this._rect.getWidth() / 2.0;
                    this._offY = 0.0;
                    return;
                }
                case 4: {
                    this._offX = 0.0;
                    this._offY = AlmaRectangleGeometry.this._rect.getHeight() / 2.0;
                }
            }
        }

        public int getID() {
            return this._id;
        }

        public Figure getFigure() {
            return AlmaRectangleGeometry.this._parentFigure;
        }

        public Point2D getPoint() {
            this.offset();
            Point2D.Double double_ = new Point2D.Double(AlmaRectangleGeometry.this._rect.getCenterX() + this._offX, AlmaRectangleGeometry.this._rect.getCenterY() + this._offY);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(AlmaRectangleGeometry.this.getRotateAngle(), AlmaRectangleGeometry.this.getRotateCenter().getX(), AlmaRectangleGeometry.this.getRotateCenter().getY());
            affineTransform.transform(double_, double_);
            return double_;
        }

        public double getX() {
            return this.getPoint().getX();
        }

        public double getY() {
            return this.getPoint().getY();
        }

        public void translate(double d, double d2) {
            Point2D point2D = this.getPoint();
            Point2D point2D2 = this.getPoint();
            point2D2.setLocation(point2D2.getX() + d, point2D2.getY() + d2);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(-AlmaRectangleGeometry.this.getRotateAngle(), AlmaRectangleGeometry.this.getRotateCenter().getX(), AlmaRectangleGeometry.this.getRotateCenter().getY());
            affineTransform.transform(point2D, point2D);
            affineTransform.transform(point2D2, point2D2);
            double d3 = point2D2.getX() - point2D.getX();
            double d4 = point2D2.getY() - point2D.getY();
            double d5 = AlmaRectangleGeometry.this._rect.getX();
            double d6 = AlmaRectangleGeometry.this._rect.getY();
            double d7 = d5 + AlmaRectangleGeometry.this._rect.getWidth();
            double d8 = d6 + AlmaRectangleGeometry.this._rect.getHeight();
            switch (this._id) {
                case 0: {
                    d7 += d3;
                    d8 += d4;
                    break;
                }
                case 1: {
                    d7 += d3;
                    break;
                }
                case 2: {
                    d6 += d4;
                    break;
                }
                case 3: {
                    d5 += d3;
                    break;
                }
                case 4: {
                    d8 += d4;
                }
            }
            switch (this._id) {
                case 0: 
                case 1: {
                    if (d7 < d5 + AlmaRectangleGeometry.this._minSize || AlmaRectangleGeometry.this._xOvershoot < 0.0) {
                        AlmaRectangleGeometry.this._xOvershoot += d3 - (d5 + AlmaRectangleGeometry.this._minSize - (d7 - d3));
                        d7 = d5 + AlmaRectangleGeometry.this._minSize;
                        break;
                    }
                    AlmaRectangleGeometry.this._xOvershoot = 0.0;
                    break;
                }
                case 3: {
                    if (d5 > d7 - AlmaRectangleGeometry.this._minSize || AlmaRectangleGeometry.this._xOvershoot < 0.0) {
                        AlmaRectangleGeometry.this._xOvershoot += d3 - (d5 + AlmaRectangleGeometry.this._minSize - (d7 - d3));
                        d5 = d7 - AlmaRectangleGeometry.this._minSize;
                        break;
                    }
                    AlmaRectangleGeometry.this._xOvershoot = 0.0;
                }
            }
            switch (this._id) {
                case 2: {
                    if (d6 > d8 - AlmaRectangleGeometry.this._minSize || AlmaRectangleGeometry.this._yOvershoot < 0.0) {
                        AlmaRectangleGeometry.this._yOvershoot += d4 - (d6 + AlmaRectangleGeometry.this._minSize - (d8 - d4));
                        d6 = d8 - AlmaRectangleGeometry.this._minSize;
                        break;
                    }
                    AlmaRectangleGeometry.this._yOvershoot = 0.0;
                    break;
                }
                case 0: 
                case 4: {
                    if (d8 < d6 + AlmaRectangleGeometry.this._minSize || AlmaRectangleGeometry.this._yOvershoot < 0.0) {
                        AlmaRectangleGeometry.this._yOvershoot += d4 - (d6 + AlmaRectangleGeometry.this._minSize - (d8 - d4));
                        d8 = d6 + AlmaRectangleGeometry.this._minSize;
                        break;
                    }
                    AlmaRectangleGeometry.this._yOvershoot = 0.0;
                }
            }
            AlmaRectangleGeometry.this._rect.setFrameFromDiagonal(d5, d6, d7, d8);
        }

        public void setPoint(Point2D point2D) {
            this.translate(point2D.getX() - this.getX(), point2D.getY() - this.getY());
        }

        public String toString() {
            return "id=" + this._id + ", _offX=" + this._offX + ", _offY=" + this._offY;
        }
    }
}

