/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.MendMyStruct;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ProjectBackupAction
extends OTAction {
    public static final String timestampRegex = ".*([0-9]{8}_[0-9]{4}).*";
    public static final FilenameFilter backupFileFilter = (file, string) -> string.matches(timestampRegex) && string.endsWith(".aot");
    private final ObservingToolGui gui;

    public ProjectBackupAction(@NonNull ObservingToolGui observingToolGui) {
        if (observingToolGui == null) {
            throw new NullPointerException("gui is marked non-null but is null");
        }
        this.gui = observingToolGui;
    }

    private void deleteOutOfDateProjectFileBackups() {
        File file = InitServices.ALMAOT_BACKUP_FOLDER;
        if (!(file.exists() && file.canWrite() && file.canRead())) {
            return;
        }
        for (File file2 : file.listFiles(backupFileFilter)) {
            BasicFileAttributes basicFileAttributes;
            Path path = Paths.get(file2.getPath(), new String[0]);
            BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            try {
                basicFileAttributes = basicFileAttributeView.readAttributes();
            }
            catch (IOException iOException) {
                Log.logger(ObservingToolController.class).warning("Unable to determine file creation time " + iOException.getMessage());
                continue;
            }
            Instant instant = Instant.ofEpochMilli(basicFileAttributes.creationTime().toMillis());
            Instant instant2 = Instant.now().minus(1296000L, ChronoUnit.SECONDS);
            if (!instant.isBefore(instant2)) continue;
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                Log.logger(ObservingToolController.class).warning("Cannot delete file " + String.valueOf(path) + " " + iOException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        this.deleteOutOfDateProjectFileBackups();
        File file = InitServices.ALMAOT_BACKUP_FOLDER;
        file.mkdirs();
        if (!(file.exists() && file.canWrite() && file.canRead())) {
            Log.logger(ProjectBackupAction.class).warning("Unable to setup back up directory " + String.valueOf(file));
            return;
        }
        File file2 = this.gui.primaryProjectCompartment().getFileLocation();
        ObsProject obsProject = this.gui.getPrimaryProject();
        if (obsProject == null) {
            return;
        }
        String string = new SimpleDateFormat("yyyyMMdd_HHmm").format(Calendar.getInstance().getTime());
        if (file2 == null) {
            object2 = obsProject.gettrueCode();
            file2 = StringUtils.isEmpty((CharSequence)object2) || ((String)object2).equalsIgnoreCase("None Assigned") ? new File(file, "~UnsavedProject_" + string + ".aot") : new File(file, "~" + (String)object2 + "_" + string + ".aot");
        } else {
            object2 = FilenameUtils.getBaseName((String)file2.getAbsolutePath());
            assert (object2 != null);
            object = "~" + (String)object2 + "_" + string + ".aot";
            object = ((String)object).replace("~~", "~");
            file2 = new File(file, (String)object);
        }
        object2 = null;
        try {
            object = file2.getCanonicalPath();
            File file3 = new File((String)object);
            Log.logger(ProjectBackupAction.class).fine("Backup file : " + (String)object + " created");
            object2 = new FileOutputStream(file3);
            MendMyStruct.sanitizeEntityRefs(obsProject);
            ImpexFactory.getInstance().exportProject(obsProject, (OutputStream)object2, true, false);
            ((OutputStream)object2).close();
        }
        catch (EntityException | UnknownEntityException | UnknownEntityPartException | IOException throwable) {
            Log.logger(ProjectBackupAction.class).warning("Unable to save backup file : " + throwable.getMessage());
        }
        finally {
            if (object2 != null) {
                try {
                    ((OutputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

