/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.PythonInteractor;
import alma.obsprep.ot.actions.PythonPerformer;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.widgets.FixedScroller;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class Python
extends OTAction
implements PythonInteractor {
    private JFileChooser chooser;

    public Python() {
        PythonPerformer pythonPerformer;
        PythonFileFilter pythonFileFilter = new PythonFileFilter(this);
        this.chooser = GuiFactory.getFactory().giveFileChooser("python-script");
        this.chooser.setFileFilter(pythonFileFilter);
        try {
            pythonPerformer = new PythonPerformer(this);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.error(iOException.getMessage());
            return;
        }
        this.setPerformer(pythonPerformer);
    }

    @Override
    public boolean isGUI() {
        return true;
    }

    @Override
    public String getScriptPathname() {
        int n = this.chooser.showOpenDialog(null);
        if (n != 0) {
            return null;
        }
        File file = this.chooser.getSelectedFile();
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.error(iOException.getMessage());
            iOException.printStackTrace();
        }
        return string;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, new FixedScroller(string, 500, 200));
    }

    private class PythonFileFilter
    extends FileFilter {
        private PythonFileFilter(Python python) {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = FileUtilities.getExtension(file);
            return string != null && string.equals("py");
        }

        @Override
        public String getDescription() {
            return "Python source files";
        }
    }
}

