/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.actions.ValidateInteractor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.ProblemLogger;
import alma.obsprep.ot.valdef.ValidatorSet;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.OTProgressPanel;
import javax.swing.SwingWorker;

public class ValidatePerformer
extends Performer {
    public ValidatePerformer(ValidateInteractor validateInteractor) {
        super(validateInteractor);
    }

    @Override
    public void perform() {
        final int n = MiscUtils.currentMemoryLoad();
        MiscUtils.resetJCSCache();
        final ValidateInteractor validateInteractor = (ValidateInteractor)this.getGui();
        final ObsProject obsProject = validateInteractor.getObsProject();
        validateInteractor.setFeedbackVisible();
        validateInteractor.saveCurrentValues();
        ObservingToolController.getOTGui().ensureSGNodeInTreeSelectedThisOTSession(obsProject);
        final OTProgressPanel oTProgressPanel = OTProgressPanel.makeProgressPanel("Validating", GUIUtilities.getParentWindow());
        oTProgressPanel.setTitle("The project is being validated, please wait.");
        oTProgressPanel.start();
        final ValidatorSet validatorSet = validateInteractor.getValidators();
        final ProblemListModel problemListModel = validateInteractor.getProblemListModel();
        final ProblemLogger problemLogger = new ProblemLogger(problemListModel);
        problemListModel.addProblemListListener(problemLogger);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(this){

            @Override
            public Void doInBackground() {
                oTProgressPanel.addActionListener(actionEvent -> {
                    validatorSet.shutdownValidation();
                    this.cancel(true);
                });
                validatorSet.validate((BusinessObject)obsProject, problemListModel);
                problemListModel.removeProblemListListener(problemLogger);
                validateInteractor.getModelsToRefresh().stream().forEach(Model::publish);
                int n2 = MiscUtils.currentMemoryLoad() - n;
                if (n2 > 0) {
                    Log.logger((Object)this).fine("This validation run required " + n2 + " % of the available memory");
                }
                return null;
            }

            @Override
            public void done() {
                oTProgressPanel.stop();
            }
        };
        swingWorker.execute();
    }
}

