/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.Circle;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.CircleModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CircleEditor
extends EditorWithGridBagLayout {
    private SkyCoordsEditor centreEditor = null;
    private ValueUnitPairEditor radiusEditor = null;
    private ValueUnitPairEditor spacingEditor = null;

    public CircleEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    private CircleModel getMyModel() {
        return (CircleModel)this.getModel();
    }

    @Override
    protected void build() {
        super.build("Circle");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = null;
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.nameFID, string + " Name", "The name of this " + string);
        this.addNonCollapsingGroup(jPanel, "");
        jPanel = this.createNewGroup();
        gridBagLayout = this.createNewLayout(jPanel);
        gridBagConstraints = this.createNewConstraints();
        this.centreEditor = this.addSkyCoordinates(jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getCentreModel(), "Centre", "The centre of this circle");
        this.radiusEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getRadiusModel(), "Radius", "The radius of the circle");
        this.radiusEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.radiusEditor));
        this.spacingEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getSpacingModel(), "Spacing", "The spacing between beams");
        this.spacingEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.spacingEditor));
        this.addGroup(jPanel, string);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FieldIDs.nameFID) {
            super.update(fieldID, object);
        } else if (fieldID == this.getMyModel().radiusUnitFID || fieldID == this.getMyModel().radiusValueFID) {
            this.radiusEditor.update(fieldID, object);
        } else if (fieldID == this.getMyModel().spacingUnitFID || fieldID == this.getMyModel().spacingValueFID) {
            this.spacingEditor.update(fieldID, object);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        CircleModel circleModel = new CircleModel(null);
        CircleEditor circleEditor = new CircleEditor(circleModel);
        Circle circle = Circle.createCircle();
        circleModel.setDocument((Object)circle);
        EditorWithGridBagLayout.runTestApp(circleEditor);
    }
}

