/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.FieldImportExporter;
import alma.obsprep.ot.editors.schedblock.IndividualPointingsExportOptions;
import alma.obsprep.ot.editors.schedblock.PointingExportFileDetails;
import alma.obsprep.ot.editors.schedblock.PointingImpexFactory;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import lombok.NonNull;

public class PointingPatternImporterExporter
extends FieldImportExporter
implements PointingImpexFactory.PointingImpexInterface {
    private final PointingPatternModel pointingPatternModel;

    public PointingPatternImporterExporter(@NonNull Model model) {
        if (model == null) {
            throw new NullPointerException("pointingPatternModel is marked non-null but is null");
        }
        if (!(model instanceof PointingPatternModel)) {
            throw new IllegalArgumentException("pointingSource should be PointingPatternModel");
        }
        this.pointingPatternModel = (PointingPatternModel)model;
    }

    @Override
    public void importPointingsFromFile(@NonNull JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("parentComponent is marked non-null but is null");
        }
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("ImportPointings");
        jFileChooser.setDialogTitle("Import Pointings");
        int n = jFileChooser.showOpenDialog(jComponent);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            assert (file != null);
            assert (this.pointingPatternModel != null);
            if (file.exists()) {
                this.pointingPatternModel.importPointingsFromFile(file, false);
            } else {
                GUIUtilities.error(null, "File" + String.valueOf(file) + " does not exist.");
            }
        }
    }

    @Override
    public void exportPointingsToFile(@NonNull JComponent jComponent) {
        PointingExportFileDetails pointingExportFileDetails;
        if (jComponent == null) {
            throw new NullPointerException("parentComponent is marked non-null but is null");
        }
        boolean bl = !this.pointingPatternModel.isSACA();
        boolean bl2 = this.pointingPatternModel.isACAEnabled();
        try {
            pointingExportFileDetails = this.getPointingFileNames(bl, bl2, jComponent);
        }
        catch (FieldImportExporter.AbortPointingExportException abortPointingExportException) {
            return;
        }
        if (pointingExportFileDetails.getDialogueRetCode() == 0) {
            IndividualPointingsExportOptions individualPointingsExportOptions = pointingExportFileDetails.getExpOpts();
            if (individualPointingsExportOptions.isAbsoluteCoords()) {
                pointingExportFileDetails.getTwelveMFile().ifPresent(file -> this.pointingPatternModel.exportAbsoluteCoordsToFile((File)file, individualPointingsExportOptions.getAbsCoordsType(), Optional.of(Antenna.ANTENNA_12M)));
                pointingExportFileDetails.getAca7MFile().ifPresent(file -> this.pointingPatternModel.exportAbsoluteCoordsToFile((File)file, individualPointingsExportOptions.getAbsCoordsType(), Optional.of(Antenna.ANTENNA_7M)));
            } else {
                pointingExportFileDetails.getTwelveMFile().ifPresent(file -> this.pointingPatternModel.exportOffsetCoordsToFile((File)file, individualPointingsExportOptions.getOffsetCoordsType(), Optional.of(Antenna.ANTENNA_12M)));
                pointingExportFileDetails.getAca7MFile().ifPresent(file -> this.pointingPatternModel.exportOffsetCoordsToFile((File)file, individualPointingsExportOptions.getOffsetCoordsType(), Optional.of(Antenna.ANTENNA_7M)));
            }
        }
    }
}

