/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.actions;

import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.ScienceGoalSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualAction;
import alma.obsprep.ot.editors.spatialvisual.mapper.OverlayPointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.ShowPointingsException;
import alma.obsprep.ot.gui.resources.Icons;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;

public class SpatialVisualActionShowPointings
extends SpatialVisualAction
implements PropertyChangeListener {
    public static final String actionName = "Show Pointings";

    public SpatialVisualActionShowPointings(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel, BaseSpatialVisualModel baseSpatialVisualModel) {
        super(almaNavigatorImageDisplayPanel, actionName, Icons.getIcon("mosaic.gif"), true);
        if (baseSpatialVisualModel instanceof ScienceGoalSpatialVisualModel) {
            ScienceGoalSpatialVisualModel scienceGoalSpatialVisualModel = (ScienceGoalSpatialVisualModel)baseSpatialVisualModel;
            OverlayPointingMapperModel overlayPointingMapperModel = scienceGoalSpatialVisualModel.getVisualModelHelper().getOverlayPointingMapperModel();
            overlayPointingMapperModel.addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean toggles() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        try {
            this.imagePanel.getMapperManager().getRoiMapper().showPointings(jToggleButton.isSelected());
        }
        catch (ShowPointingsException showPointingsException) {
            jToggleButton.setSelected(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        this.setEnabled(bl);
        AbstractButton abstractButton = (AbstractButton)this.getValue("Action.button");
        if (abstractButton != null) {
            abstractButton.setToolTipText(bl ? "Show pointing positions." : "<html>Show pointing positions. <b>Not available as maximum number exceeded.</b></html>");
            if (!bl) {
                abstractButton.setSelected(false);
                try {
                    this.imagePanel.getMapperManager().getRoiMapper().showPointings(false);
                }
                catch (ShowPointingsException showPointingsException) {
                    // empty catch block
                }
            }
            abstractButton.setEnabled(bl);
        }
    }
}

