/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.valuetypes.OffsetModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.SkyCoordinates;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OffsetEditor
extends EditorWithGridBagLayout {
    private boolean isSystemUserModifiable = true;
    protected static final String[] SYSTEMS = new String[]{SkyCoordinates.SYSTEM_ICRS, "FK5 J2000", SkyCoordinates.SYSTEM_GALACTIC, SkyCoordinates.SYSTEM_ECLIPTIC, SkyCoordinates.SYSTEM_HORIZON, SkyCoordinates.SYSTEM_AZEL};
    protected static final int DEFAULT_SYSTEM_INDEX = 1;
    protected boolean updatePending = false;
    private DialogId dialogId = new DialogId("OffsetEditor.ReferenceSystem", "Display offset coordinates reference system change message");
    public static final FieldID FID_SYSTEM = new FieldID("OffsetEditor.System");
    public static final FieldID FID_OFFSETRA = new FieldID("OffsetEditor.Ra");
    public static final FieldID FID_OFFSETDEC = new FieldID("OffsetEditor.Dec");
    private boolean isCollapsible = true;
    private JLabel offsetLatitudeLabel;
    private JLabel offsetLongitudeLabel;
    private CoordSysItemListener coordSystemItemListener;

    public OffsetEditor(boolean bl, Model model, boolean bl2) {
        this.isCollapsible = bl2;
        this.isSystemUserModifiable = bl;
        this.setModel(model);
        this.build();
        model.publish();
    }

    public OffsetEditor(Model model) {
        this(true, model, true);
    }

    @Override
    protected void build() {
        super.build("Offset");
    }

    @Override
    protected void addComponents(String string) {
        OffsetModel offsetModel = (OffsetModel)this.getModel();
        JComboBox<String> jComboBox = new JComboBox<String>(SYSTEMS);
        this.constraints.insets = new Insets(3, 3, 3, 3);
        this.createUILabelMapping(jComboBox, SkyCoordinates.SYSTEM_J2000, "FK5 J2000");
        jComboBox.setEditable(false);
        jComboBox.setSelectedIndex(1);
        this.initEvents(jComboBox, FID_SYSTEM);
        if (this.isSystemUserModifiable) {
            this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "System", jComboBox);
        }
        this.coordSystemItemListener = new CoordSysItemListener();
        jComboBox.addItemListener(this.coordSystemItemListener);
        this.offsetLongitudeLabel = new JLabel("Offset(Longitude)");
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)this, this.layout, this.constraints, offsetModel.getOffsetRAModel(), this.offsetLongitudeLabel, "Offset position in Longitude");
        valueUnitPairEditor.getInput().setName("OffsetEditor.LongitudeText");
        valueUnitPairEditor.getUnits().setName("OffsetEditor.LongitudeUnitsCombo");
        this.register(valueUnitPairEditor, FID_OFFSETRA);
        this.offsetLatitudeLabel = new JLabel("Offset(Latitude)");
        valueUnitPairEditor = this.addValueUnitPair((JComponent)this, this.layout, this.constraints, offsetModel.getOffsetDecModel(), this.offsetLatitudeLabel, "Offset position in Latitude");
        valueUnitPairEditor.getInput().setName("OffsetEditor.LatitudeText");
        valueUnitPairEditor.getUnits().setName("OffsetEditor.LatitudeUnitsCombo");
        this.register(valueUnitPairEditor, FID_OFFSETDEC);
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(FID_OFFSETDEC);
        ValueUnitPairEditor valueUnitPairEditor2 = (ValueUnitPairEditor)this.getComponent(FID_OFFSETRA);
        return Arrays.asList(this.offsetLatitudeLabel, this.offsetLongitudeLabel, valueUnitPairEditor.getUnits(), valueUnitPairEditor.getInput(), valueUnitPairEditor2.getUnits(), valueUnitPairEditor2.getInput());
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.isCollapsible) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        this.updatePending = true;
        if (fieldID.equals(CoordsEditor.FID_COORDS_SYSTEM)) {
            String string = (String)object;
            this.coordSystemItemListener.updateCoordinateSystem(string);
        }
        super.update(fieldID, object);
        this.updatePending = false;
    }

    public static OffsetEditorBuilder getOffsetBuilder() {
        return new OffsetEditorBuilder();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Offset Editor");
        jFrame.setDefaultCloseOperation(3);
        OffsetModel offsetModel = new OffsetModel(SkyCoordinates.createOffsetCoordinates());
        OffsetEditorBuilder offsetEditorBuilder = OffsetEditor.getOffsetBuilder();
        offsetEditorBuilder.withIsCollapsible(true).withIsSystemUserModifiable(true).withModel(offsetModel);
        OffsetEditor offsetEditor = offsetEditorBuilder.build();
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().add(offsetEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class CoordSysItemListener
    implements ItemListener {
        private String previousValue = null;

        CoordSysItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string = itemEvent.getItem().toString();
            string = OffsetEditor.this.getUILabelToBOMapping((JComponent)itemEvent.getSource(), string);
            this.updateCoordinateSystem(string);
        }

        public void updateCoordinateSystem(String string) {
            if (string.equals(this.previousValue)) {
                return;
            }
            if (this.previousValue == null) {
                this.previousValue = string;
                return;
            }
            String string2 = this.previousValue;
            this.previousValue = string;
            if (OffsetEditor.this.updatePending) {
                return;
            }
            String string3 = "Changed coordinate system type from \"" + string2 + "\" to \"" + string + "\",\nbut no coordinate conversion was performed";
            SwingUtilities.invokeLater(() -> GUIUtilities.infoWithDoNotShowAgain(OffsetEditor.this.dialogId, string3));
        }
    }

    public static class OffsetEditorBuilder {
        private boolean isSystemUserModifiable = true;
        private Model model = null;
        private boolean isCollapsible = true;

        public OffsetEditorBuilder withIsSystemUserModifiable(boolean bl) {
            this.isSystemUserModifiable = bl;
            return this;
        }

        public OffsetEditorBuilder withIsCollapsible(boolean bl) {
            this.isCollapsible = bl;
            return this;
        }

        public OffsetEditorBuilder withModel(Model model) {
            this.model = model;
            return this;
        }

        public OffsetEditor build() {
            if (this.model == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: model");
            }
            return new OffsetEditor(this.isSystemUserModifiable, this.model, this.isCollapsible);
        }
    }
}

