/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintListEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintTableModel;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.TreeMap;

public class VisitConstraintsListModel
extends Model
implements ModelChangeSubscriber {
    private static final int VISIT_ID_NONE = 0;
    private VisitConstraint currentVisitConstraint = null;
    private VisitConstraintTableModel visitConstraintsTableModel = null;
    private static final DialogId DIALOG_ORDER_IMPOSSIBLE = new DialogId("VisitConstraints.ImpossibleOrder");
    private final ValueUnitPairModel requiredDelayModel = new ValueUnitPairModel();
    ValueUnitPairModel allowedMarginModel = new ValueUnitPairModel();
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static final int MIN_ADVISED_MARGIN = (int)almaPolicies.getMinAdvisedTimeMargin().getContentInUnits(Time.UNIT_D);

    public VisitConstraintsListModel(Object object) {
        super(object);
        this.visitConstraintsTableModel = new VisitConstraintTableModel(this);
        this.registerSubModel(this.allowedMarginModel);
        this.registerSubModel(this.requiredDelayModel);
    }

    public PerformanceParameters getPerformanceParameters() {
        return (PerformanceParameters)this.getDocument();
    }

    @Override
    public void publish() {
        if (this.currentVisitConstraint != null && this.currentVisitConstraint.getPreviousVisitId() == 0 && !this.currentVisitConstraint.getIsFixedStart()) {
            this.setMarginToZero();
        }
        this.allowedMarginModel.publish();
        this.requiredDelayModel.publish();
        this.fireTableDataChanged();
        this.publish(VisitConstraintListEditor.tpCountLabelFID, this.getVisitConstraintCount());
        if (this.getVisitConstraintCount() > 0) {
            this.publish(VisitConstraintListEditor.VISIT_CONSTRAINT_TABLE_FID, this.getPerformanceParameters().getVisitConstraint());
        }
    }

    private void setMarginToZero() {
        this.currentVisitConstraint.setAllowedMargin(Time.createTimeSec(0.0));
        this.currentVisitConstraint.setRequiredDelay(Time.createTimeSec(0.0));
        this.requiredDelayModel.setDocument(this.currentVisitConstraint.getRequiredDelay());
        this.allowedMarginModel.setDocument(this.currentVisitConstraint.getAllowedMargin());
        this.requiredDelayModel.publish();
        this.allowedMarginModel.publish();
    }

    private void setMargin(int n) {
        this.currentVisitConstraint.setAllowedMargin(Time.createTime((double)n, (String)Time.UNIT_D));
        this.allowedMarginModel.setDocument(this.currentVisitConstraint.getAllowedMargin());
        this.allowedMarginModel.publish();
    }

    private void fireTableDataChanged() {
        this.getVisitConstraintsTableModel().fireTableDataChanged();
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.setCurrentVisitConstraint((Object)VisitConstraint.createVisitConstraint());
        this.visitConstraintsTableModel.fireTableStructureChanged();
    }

    public void addVisitConstraint(int n) {
        this.setCurrentVisitConstraint((Object)VisitConstraint.createVisitConstraint());
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        int n2 = this.getNextFreeVisitId();
        visitConstraint.setVisitId(n2);
        visitConstraint.setIsFixedStart(false);
        int n3 = MIN_ADVISED_MARGIN / 2;
        visitConstraint.setAllowedMargin(Time.createTime((double)n3, (String)Time.UNIT_D));
        if (n2 > 1) {
            visitConstraint.setRequiredDelay(Time.createTime((double)(MIN_ADVISED_MARGIN * (n2 - 1)), (String)Time.UNIT_D));
            visitConstraint.setPreviousVisitId(1);
        } else {
            visitConstraint.setRequiredDelay(Time.createTime((double)0.0, (String)Time.UNIT_D));
            visitConstraint.setAllowedMargin(Time.createTime((double)0.0, (String)Time.UNIT_D));
            visitConstraint.setPreviousVisitId(0);
        }
        this.getPerformanceParameters().addVisitConstraint(n, visitConstraint);
        this.getVisitConstraintsTableModel().fireTableRowsInserted(n, n);
    }

    public VisitConstraint getVisitConstraint(int n) {
        return this.getPerformanceParameters().getVisitConstraint(n);
    }

    public void deleteVisitConstraint(int n) {
        if (n != -1) {
            VisitConstraint visitConstraint = this.getPerformanceParameters().getVisitConstraint(n);
            int n2 = visitConstraint.getVisitId();
            int n3 = visitConstraint.getPreviousVisitId();
            this.adjustConstraintDependenciesOnDeletedRow(n2, n3);
            this.getPerformanceParameters().removeVisitConstraint(visitConstraint);
            this.orderVisitConstraints(n);
            this.getVisitConstraintsTableModel().fireTableRowsDeleted(n, n);
        }
    }

    public void clearVisitConstraintList() {
        this.setCurrentVisitConstraint(null);
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            performanceParameters.clearVisitConstraint();
        }
        this.fireTableDataChanged();
        this.publish();
    }

    private void adjustConstraintDependenciesOnDeletedRow(int n, int n2) {
        boolean bl = n2 == 0;
        for (VisitConstraint visitConstraint : this.getPerformanceParameters().getVisitConstraint()) {
            if (visitConstraint.getPreviousVisitId() == n) {
                visitConstraint.setPreviousVisitId(n2);
            }
            if (!bl) continue;
            visitConstraint.setAllowedMargin(Time.createTime((double)0.0, (String)Time.UNIT_D));
            visitConstraint.setRequiredDelay(Time.createTime((double)0.0, (String)Time.UNIT_D));
        }
    }

    public int orderVisitConstraints(int n) {
        int n2 = n;
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        int n3 = performanceParameters.getVisitConstraintCount();
        Hashtable<Integer, VisitConstraint> hashtable = new Hashtable<Integer, VisitConstraint>();
        for (VisitConstraint visitConstraint : performanceParameters.getVisitConstraint()) {
            hashtable.put(visitConstraint.getVisitId(), visitConstraint);
        }
        Hashtable hashtable2 = new Hashtable();
        TreeMap<ZonedDateTime, VisitConstraint> treeMap = new TreeMap<ZonedDateTime, VisitConstraint>();
        int n4 = n3;
        int n5 = n3 + 1;
        hashtable2.put(0, VisitConstraint.nowInUTC());
        while (n4 < n5) {
            n5 = n4;
            n4 = 0;
            for (VisitConstraint[] visitConstraintArray : hashtable.keySet()) {
                if (hashtable2.containsKey(visitConstraintArray)) continue;
                VisitConstraint visitConstraint = (VisitConstraint)((Object)hashtable.get(visitConstraintArray));
                ZonedDateTime zonedDateTime = VisitConstraint.nowInUTC();
                if (visitConstraint.getIsFixedStart()) {
                    zonedDateTime = visitConstraint.getStartTimeInDate();
                    zonedDateTime = zonedDateTime.plus(visitConstraint.getVisitId(), ChronoUnit.MILLIS);
                    ZonedDateTime zonedDateTime2 = ZonedDateTime.ofInstant(zonedDateTime.toInstant(), ZoneOffset.UTC);
                    treeMap.put(zonedDateTime2, visitConstraint);
                    hashtable2.put(visitConstraint.getVisitId(), zonedDateTime2);
                    continue;
                }
                if (hashtable2.containsKey(visitConstraint.getPreviousVisitId())) {
                    zonedDateTime = (ZonedDateTime)hashtable2.get(visitConstraint.getPreviousVisitId());
                    int n6 = (int)Math.round(visitConstraint.getRequiredDelay().getContentInUnits(Time.UNIT_S));
                    zonedDateTime = zonedDateTime.plus(n6, ChronoUnit.SECONDS);
                    zonedDateTime = zonedDateTime.plus(visitConstraint.getVisitId(), ChronoUnit.MILLIS);
                    ZonedDateTime zonedDateTime3 = ZonedDateTime.ofInstant(zonedDateTime.toInstant(), ZoneOffset.UTC);
                    treeMap.put(zonedDateTime3, visitConstraint);
                    hashtable2.put(visitConstraint.getVisitId(), zonedDateTime3);
                    continue;
                }
                ++n4;
            }
        }
        if (n3 > 1) {
            if (treeMap.size() + 1 >= hashtable.size()) {
                var10_12 = treeMap.values();
                visitConstraintArray = var10_12.toArray(new VisitConstraint[var10_12.size()]);
                int n7 = var10_12.size();
                int n8 = n7 + 10;
                for (int i = 1; i < n7 + 1; ++i) {
                    int n9 = visitConstraintArray[i - 1].getVisitId();
                    int n10 = i + n8;
                    if (n + 1 == n9) {
                        int n11;
                        n2 = n11 = i - 1;
                    }
                    for (VisitConstraint visitConstraint : visitConstraintArray) {
                        if (visitConstraint.getVisitId() == n9) {
                            visitConstraint.setVisitId(n10);
                            continue;
                        }
                        if (visitConstraint.getPreviousVisitId() != n9) continue;
                        visitConstraint.setPreviousVisitId(n10);
                    }
                }
                for (VisitConstraint visitConstraint : visitConstraintArray) {
                    visitConstraint.setVisitId(visitConstraint.getVisitId() - n8);
                    if (visitConstraint.getPreviousVisitId() <= 0) continue;
                    visitConstraint.setPreviousVisitId(visitConstraint.getPreviousVisitId() - n8);
                }
                performanceParameters.setVisitConstraint(var10_12.toArray(visitConstraintArray));
                this.getVisitConstraintsTableModel().fireTableDataChanged();
            } else {
                GUIUtilities.warning(DIALOG_ORDER_IMPOSSIBLE, "The order of these visits is not possible");
            }
        } else if (n3 == 1) {
            var10_12 = treeMap.values();
            visitConstraintArray = var10_12.toArray(new VisitConstraint[var10_12.size()]);
            visitConstraintArray[0].setVisitId(1);
            visitConstraintArray[0].setPreviousVisitId(0);
            performanceParameters.setVisitConstraint(var10_12.toArray(visitConstraintArray));
            this.getVisitConstraintsTableModel().fireTableDataChanged();
        }
        return n2;
    }

    public int getVisitConstraintCount() {
        return this.document == null ? 0 : this.getPerformanceParameters().getVisitConstraintCount();
    }

    public int getVisitConstraintsTableRowCount() {
        VisitConstraintTableModel visitConstraintTableModel = this.getVisitConstraintsTableModel();
        return visitConstraintTableModel == null ? 0 : visitConstraintTableModel.getRowCount();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        if (fieldID.equals(VisitConstraintEditor.FIXED_START_FID)) {
            boolean bl;
            boolean bl2 = object.toString().equals("Specific Date");
            if (bl2) {
                this.setMargin(MIN_ADVISED_MARGIN);
            }
            if (bl = object.toString().equals("Arbitrary Start")) {
                this.setMarginToZero();
            }
            visitConstraint.setIsFixedStart(bl2);
            if (bl2 && (visitConstraint.getStartTime() == null || visitConstraint.getStartTime() == "")) {
                visitConstraint.setStartTimeInDate(VisitConstraint.nowInUTC());
            }
            String string = visitConstraint.getStartTime();
            this.publish(VisitConstraintEditor.START_TIME_FID, string);
        } else if (fieldID.equals(VisitConstraintEditor.START_TIME_FID)) {
            visitConstraint.setStartTime((String)object);
        } else if (fieldID.equals(VisitConstraintEditor.PREVIOUS_VISIT_FID)) {
            String string = object.toString();
            int n = "None".equals(string) || string == null ? 0 : Integer.parseInt(string);
            visitConstraint.setPreviousVisitId(n);
            visitConstraint.setAllowedMargin(Time.createTime((double)0.0, (String)Time.UNIT_D));
            return string;
        }
        return object;
    }

    public boolean isFixedStart() {
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        return null == visitConstraint ? false : visitConstraint.getIsFixedStart();
    }

    public boolean allButFirstRecordRelative() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            VisitConstraint[] visitConstraintArray = this.getPerformanceParameters().getVisitConstraint();
            for (int i = 1; i < visitConstraintArray.length; ++i) {
                VisitConstraint visitConstraint = visitConstraintArray[i];
                if (!visitConstraint.getIsFixedStart()) continue;
                return false;
            }
        }
        return true;
    }

    public int getNextFreeVisitId() {
        VisitConstraint[] visitConstraintArray;
        this.getVisitConstraintCount();
        int n = 0;
        for (VisitConstraint visitConstraint : visitConstraintArray = this.getPerformanceParameters().getVisitConstraint()) {
            if (visitConstraint.getVisitId() <= n) continue;
            n = visitConstraint.getVisitId();
        }
        return n + 1;
    }

    public int getArbitraryStartVisitID() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            VisitConstraint[] visitConstraintArray;
            for (VisitConstraint visitConstraint : visitConstraintArray = this.getPerformanceParameters().getVisitConstraint()) {
                if (visitConstraint.getIsFixedStart() || visitConstraint.getPreviousVisitId() != 0) continue;
                return visitConstraint.getVisitId();
            }
        }
        return -1;
    }

    public String[] getValidPreviousVisitIds() {
        Object[] objectArray;
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        if (visitConstraint == null) {
            return new String[0];
        }
        int n = visitConstraint.getVisitId();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(n));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (null != this.document) {
            for (VisitConstraint visitConstraint2 : objectArray = this.getPerformanceParameters().getVisitConstraint()) {
                Integer n2 = visitConstraint2.getVisitId();
                if (null == n2) continue;
                int n3 = visitConstraint2.getPreviousVisitId();
                if (arrayList.contains(n2) || !visitConstraint2.getIsFixedStart() && arrayList.contains(n3)) {
                    arrayList.add(n2);
                    continue;
                }
                arrayList2.add(Integer.toString(n2));
            }
        }
        objectArray = new String[arrayList2.size()];
        objectArray = (String[])arrayList2.toArray(objectArray);
        return objectArray;
    }

    public void setCurrentVisitConstraint(Object object) {
        this.currentVisitConstraint = (VisitConstraint)((Object)object);
        if (this.currentVisitConstraint != null) {
            this.requiredDelayModel.setDocument(this.currentVisitConstraint.getRequiredDelay());
            this.allowedMarginModel.setDocument(this.currentVisitConstraint.getAllowedMargin());
            this.requiredDelayModel.publish();
            this.allowedMarginModel.publish();
        }
    }

    public void updateAssociatedeNote(String string) {
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        if (null != visitConstraint) {
            visitConstraint.setNote(string);
        }
    }

    public VisitConstraint getCurrentVisitConstraint() {
        return this.currentVisitConstraint;
    }

    public VisitConstraintTableModel getVisitConstraintsTableModel() {
        return this.visitConstraintsTableModel;
    }

    public ValueUnitPairModel getRequiredDelayModel() {
        return this.requiredDelayModel;
    }

    public ValueUnitPairModel getAllowedMarginModel() {
        return this.allowedMarginModel;
    }
}

