/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.obsprep.util.MiscUtils;
import alma.ssr.observingmodes.CalibrationType;
import alma.ssr.observingmodes.ObservingControlScript;
import alma.ssr.observingmodes.ObservingMode;
import alma.ssr.observingmodes.Property;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class ObservingModeProperties {
    private String modeName;
    private String modeDocument;
    private ObservingMode obsMode = null;
    private ObservingControlScript obsScript = null;

    public ObservingModeProperties() {
        this.modeName = "Unknown";
        this.modeDocument = "Unknown";
    }

    public ObservingModeProperties(String string, String string2) {
        this.modeName = string;
        this.modeDocument = string2;
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getModeDocument() {
        return this.modeDocument;
    }

    public String getModeType() {
        if (this.obsMode != null) {
            return this.obsMode.getType().toString();
        }
        return "";
    }

    public String getControlScript() {
        if (this.obsScript != null) {
            return this.obsScript.getScriptname();
        }
        return "";
    }

    public boolean getRunQuickLook() {
        if (this.obsMode != null) {
            return this.obsMode.getRunQuickLook();
        }
        return false;
    }

    public boolean getStandardMode() {
        if (this.obsMode != null) {
            return this.obsMode.getStandardMode();
        }
        return false;
    }

    public CalibrationType[] getModeCalibrations() {
        if (this.obsMode != null) {
            return this.obsMode.getCalibrations().getCalibrationType();
        }
        return new CalibrationType[0];
    }

    public Property[] getModeProperties() {
        if (this.obsMode != null) {
            return this.obsMode.getObservingScript().getProperty();
        }
        return new Property[0];
    }

    public Property[] getScriptProperties() {
        if (this.obsScript != null) {
            return this.obsScript.getProperty();
        }
        return new Property[0];
    }

    public String getScriptPropertyType(String string) {
        for (Property property : this.getScriptProperties()) {
            if (!property.getName().equals(string)) continue;
            return property.getType();
        }
        return null;
    }

    public String getScriptPropertyUnit(String string) {
        for (Property property : this.getScriptProperties()) {
            if (!property.getName().equals(string)) continue;
            return property.getUnit();
        }
        return null;
    }

    public String getScriptPropertyMinValue(String string) {
        for (Property property : this.getScriptProperties()) {
            if (!property.getName().equals(string)) continue;
            return property.getMinValue();
        }
        return null;
    }

    public String getScriptPropertyMaxValue(String string) {
        for (Property property : this.getScriptProperties()) {
            if (!property.getName().equals(string)) continue;
            return property.getMaxValue();
        }
        return null;
    }

    private String getDocument(String string) {
        String string2 = "";
        Object object = "";
        URL uRL = MiscUtils.findResource(null, string);
        if (uRL == null) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                object = (String)object + string2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public void readObservingModeDocument() {
        this.readObservingModeDocument(null);
    }

    public void readObservingModeDocument(String string) {
        String string2 = "";
        if (string != null) {
            this.modeDocument = string;
        }
        if ((string2 = this.getDocument(this.modeDocument)) == null) {
            return;
        }
        StringReader stringReader = new StringReader(string2);
        try {
            this.obsMode = ObservingMode.unmarshalObservingMode((Reader)stringReader);
        }
        catch (MarshalException marshalException) {
            marshalException.printStackTrace();
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
        this.readObservingScriptDocument();
    }

    public void readObservingScriptDocument() {
        String string = "";
        String string2 = "";
        if (this.obsMode == null) {
            return;
        }
        string = this.obsMode.getObservingScript().getFile();
        if (string == "") {
            return;
        }
        string2 = this.getDocument(string);
        if (string2 == null) {
            return;
        }
        StringReader stringReader = new StringReader(string2);
        try {
            this.obsScript = ObservingControlScript.unmarshalObservingControlScript((Reader)stringReader);
        }
        catch (MarshalException marshalException) {
            marshalException.printStackTrace();
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
    }
}

