/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class LinesWithinSSPSpectralWindowsFilter
implements Matcher<SpectralLine> {
    private static CacheAccess<ScienceSpectralWindow, Optional<FrequencyRange>> imageSPWCache = JCS.getInstance((String)"imageSPWCache");
    private static CacheAccess<SpectralSetupParameters, Velocity> velocityCache = JCS.getInstance((String)"velocityCache");
    private SpectralSetupParameters spectralSetupParameters;

    public LinesWithinSSPSpectralWindowsFilter(@NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("spectralSetupParameters is marked non-null but is null");
        }
        this.spectralSetupParameters = spectralSetupParameters;
        imageSPWCache.clear();
        velocityCache.clear();
    }

    public boolean matches(SpectralLine spectralLine) {
        Velocity velocity = (Velocity)((Object)velocityCache.get((Object)this.spectralSetupParameters));
        if (velocity == null) {
            velocity = this.spectralSetupParameters.getSourceVelocity();
            velocityCache.put((Object)this.spectralSetupParameters, (Object)velocity);
        }
        boolean bl = this.spectralSetupParameters.isSingleContinuum();
        Frequency frequency = spectralLine.getFrequency();
        double d = frequency.getContentInGHz();
        for (ScienceSpectralWindow scienceSpectralWindow : this.spectralSetupParameters.getScienceSpectralWindow()) {
            double d2 = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(velocity).getContentInGHz();
            double d3 = bl ? velocity.reverseShift(scienceSpectralWindow.getCenterFrequency()).getContentInGHz() : scienceSpectralWindow.getCenterFrequency().getContentInGHz();
            double d4 = d2 / 2.0;
            double d5 = d3 - d4;
            double d6 = d3 + d4;
            if (d5 <= d && d6 >= d) {
                return true;
            }
            Optional<FrequencyRange> optional = (Optional<FrequencyRange>)imageSPWCache.get((Object)scienceSpectralWindow);
            if (optional == null) {
                optional = this.spectralSetupParameters.getSPWImageFrequencyRange(scienceSpectralWindow);
                imageSPWCache.put((Object)scienceSpectralWindow, optional);
            }
            if (!optional.isPresent() || !optional.get().contains(frequency)) continue;
            return true;
        }
        return false;
    }
}

