/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.TargetData;
import alma.obsprep.services.generator.refactored.SchedBlockConfiguratorInterface;
import alma.valuetypes.Time;
import java.util.List;
import lombok.NonNull;

class TPSchedBlockFullDiscSolarObservingConfigurator
implements SchedBlockConfiguratorInterface {
    @NonNull
    private final SchedBlock sb;

    private void setReferencePositionTimingParameters(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("referencePosition is marked non-null but is null");
        }
        reference.setIntegrationTime(Time.createTimeSec(10.0));
        reference.setSubScanDuration(Time.createTimeSec(9.216));
    }

    @Override
    public void configureSB() {
        List<Target> list = this.sb.getObservingGroup(1).getAllOrderedTargets(ScienceParameters.scienceParametersFilter);
        list.stream().map(TargetData::getFieldSource).forEach(fieldSource -> this.setReferencePositionTimingParameters(fieldSource.getReference(0)));
    }

    public TPSchedBlockFullDiscSolarObservingConfigurator(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.sb = schedBlock;
    }
}

