/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.ot.editors.sciencegoals.TJEditorEnum;
import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import alma.obsprep.services.summaryfeedback.TextPanelHelper;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import lombok.NonNull;

public class ScienceGoalExporter
extends DefaultPdfExporter {
    protected ScienceGoalSummaryView sgSummaryView;

    protected ScienceGoalExporter(ScienceGoalSummaryView scienceGoalSummaryView) {
        super(scienceGoalSummaryView);
        this.sgSummaryView = scienceGoalSummaryView;
    }

    @Override
    protected void exportToPdfPage(Document document, PdfWriter pdfWriter, Rectangle rectangle) {
        this.exportToScienceGoalToPDFPage(document, pdfWriter, 1);
    }

    protected int exportToScienceGoalToPDFPage(@NonNull Document document, @NonNull PdfWriter pdfWriter, int n) {
        if (document == null) {
            throw new NullPointerException("pdfDocument is marked non-null but is null");
        }
        if (pdfWriter == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        int n2 = 0;
        if (this.sgSummaryView == null) {
            return n2;
        }
        PageSplitter pageSplitter = new PageSplitter(List.of(this.sgSummaryView.headerPanel, this.sgSummaryView.fieldInfoPanel, this.sgSummaryView.spectralInfoPanel, this.sgSummaryView.initalTargetsPanel, this.sgSummaryView.additionalTargetsPanel));
        JLabel jLabel = new JLabel();
        JPanel jPanel = this.addHeaderLabelToView(this.sgSummaryView, jLabel);
        this.doLayout(jPanel);
        for (int i = 0; i < pageSplitter.getNumberOfPages(); ++i) {
            pageSplitter.showPage(i);
            jLabel.setText("SG-" + n);
            this.addPanelToPDFDocument(pdfWriter, jPanel);
            n2 = this.addNewPage(document, n2);
        }
        this.sgSummaryView.technicalJustificationsSections.put(TJEditorEnum.ED_SENSITIVITY_COMMENTS, this.sgSummaryView.sensitivityCommentPanel);
        this.sgSummaryView.technicalJustificationsSections.put(TJEditorEnum.ED_CORR_COMMENTS, this.sgSummaryView.correlatorCommentPanel);
        return this.addTechnicalJustificationSubpanels(this.sgSummaryView.technicalJustificationsSections, document, pdfWriter, n2, "SG-" + n);
    }

    private int addTechnicalJustificationSubpanels(TreeMap<TJEditorEnum, JComponent> treeMap, @NonNull Document document, PdfWriter pdfWriter, int n, String string) {
        if (document == null) {
            throw new NullPointerException("pdfDocument is marked non-null but is null");
        }
        if (treeMap == null) {
            return n;
        }
        Iterator<JComponent> iterator = treeMap.values().iterator();
        if (iterator == null || !iterator.hasNext()) {
            return n;
        }
        TextPanelHelper textPanelHelper = new TextPanelHelper(this, 1000, 350);
        textPanelHelper.createPage(string);
        int n2 = textPanelHelper.pageHeight;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (((Container)object).getComponents().length > 0 && ((Container)object).getComponent(0) instanceof JTextComponent) {
                object = (JTextComponent)((Container)object).getComponent(0);
            }
            if ((n2 = this.fitTextIntoAvailableSpaceInTextPanel(textPanelHelper, (JComponent)object, n2, string)) != 0) continue;
            textPanelHelper.createPage(string);
        }
        for (JComponent jComponent : textPanelHelper.textPages) {
            this.addPanelToPDFDocument(pdfWriter, jComponent);
            n = this.addNewPage(document, n);
        }
        return n;
    }

    private class PageSplitter {
        private List<JPanel> allViews = new ArrayList<JPanel>();
        private int pageIndex = -1;
        private final List<List<JPanel>> pages = new ArrayList<List<JPanel>>();

        public PageSplitter(List<JPanel> list) {
            this.allViews = list;
            this.splitPages();
        }

        private void setAllViewsVisible(boolean bl) {
            this.allViews.stream().forEach(jPanel -> jPanel.setVisible(bl));
        }

        private void showPage(int n) {
            this.pageIndex = n;
            this.setView();
        }

        private void setView() {
            if (this.pageIndex == -1) {
                this.setAllViewsVisible(true);
            } else {
                this.setAllViewsVisible(false);
                for (JPanel jPanel : this.pages.get(this.pageIndex)) {
                    jPanel.setVisible(true);
                }
            }
        }

        private void splitPages() {
            ScienceGoalExporter.this.sgSummaryView.headerPanel.setVisible(true);
            ScienceGoalExporter.this.sgSummaryView.fieldInfoPanel.setVisible(true);
            ScienceGoalExporter.this.sgSummaryView.spectralInfoPanel.setVisible(true);
            ScienceGoalExporter.this.sgSummaryView.initalTargetsPanel.setVisible(true);
            JPanel[][] jPanelArrayArray = new JPanel[][]{{ScienceGoalExporter.this.sgSummaryView.headerPanel, ScienceGoalExporter.this.sgSummaryView.fieldInfoPanel, ScienceGoalExporter.this.sgSummaryView.spectralInfoPanel, ScienceGoalExporter.this.sgSummaryView.initalTargetsPanel}};
            if (ScienceGoalExporter.this.sgSummaryView.additionalTargetsPanel.isVisible()) {
                jPanelArrayArray = new JPanel[][]{{ScienceGoalExporter.this.sgSummaryView.headerPanel, ScienceGoalExporter.this.sgSummaryView.fieldInfoPanel, ScienceGoalExporter.this.sgSummaryView.spectralInfoPanel, ScienceGoalExporter.this.sgSummaryView.initalTargetsPanel}, {ScienceGoalExporter.this.sgSummaryView.additionalTargetsPanel}};
            }
            ScienceGoalExporter.this.sgSummaryView.technicalJustificationsPanel.setVisible(false);
            ScienceGoalExporter.this.sgSummaryView.choicesToBeJustifiedPanel.setVisible(false);
            for (JPanel[] jPanelArray : jPanelArrayArray) {
                ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
                for (JPanel jPanel : jPanelArray) {
                    if (!jPanel.isVisible()) continue;
                    arrayList.add(jPanel);
                }
                if (arrayList.isEmpty()) continue;
                this.pages.add(arrayList);
            }
        }

        private int getNumberOfPages() {
            return this.pages.size();
        }
    }
}

