/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import java.util.List;

public class FrequencyRange
extends VupRange<Frequency> {
    public FrequencyRange(Frequency frequency, Frequency frequency2) {
        super(frequency, frequency2);
    }

    public FrequencyRange(Range<Frequency> range) {
        super(range);
    }

    public boolean contains(Frequency frequency) {
        double d = frequency.getContentInGHz();
        return d >= ((Frequency)this.minimum).getContentInGHz() && d <= ((Frequency)this.maximum).getContentInGHz();
    }

    public static double[] centredOn(double d, double d2) {
        double d3 = d2 / 2.0;
        double[] dArray = new double[]{d - d3, d + d3};
        return dArray;
    }

    public static FrequencyRange centredOn(Frequency frequency, Frequency frequency2) {
        Frequency frequency3 = (Frequency)frequency2.half();
        Frequency frequency4 = (Frequency)frequency.minus((AbstractDoubleWithUnit)frequency3);
        Frequency frequency5 = (Frequency)frequency.plus((AbstractDoubleWithUnit)frequency3);
        return new FrequencyRange(frequency4, frequency5);
    }

    public static FrequencyRange fastCentredOn(Frequency frequency, Frequency frequency2) {
        Frequency frequency3 = (Frequency)frequency2.half(true);
        Frequency frequency4 = (Frequency)frequency.minus((AbstractDoubleWithUnit)frequency3, true);
        Frequency frequency5 = (Frequency)frequency.plus((AbstractDoubleWithUnit)frequency3, true);
        return new FrequencyRange(frequency4, frequency5);
    }

    public static FrequencyRange wholeRange(Range[] rangeArray) {
        return new FrequencyRange(VupRange.wholeRange(rangeArray));
    }

    public static FrequencyRange wholeRange(Frequency[] frequencyArray) {
        return new FrequencyRange(VupRange.wholeRange((ValueUnitPair[])frequencyArray));
    }

    public static FrequencyRange wholeRange(List<Frequency> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Illegal argument: freqArray.size() (" + list.size() + ") did not pass the test: freqArray.size() > 0");
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        for (Frequency frequency : list) {
            double d3 = frequency.getContentInGHz();
            if (bl) {
                d = d2 = d3;
                bl = false;
            }
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return new FrequencyRange(Frequency.createFrequencyGHZ(d), Frequency.createFrequencyGHZ(d2));
    }

    public static FrequencyRange centerRange(FrequencyRange[] frequencyRangeArray) {
        return new FrequencyRange(VupRange.centerRange(frequencyRangeArray));
    }
}

