/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayFuncs;

public class ImageHDU
extends BasicHDU {
    public ImageHDU(Header h, Data d) throws FitsException {
        this.myData = d;
        this.myHeader = h;
    }

    protected boolean canBePrimary() {
        return true;
    }

    protected void setPrimaryHDU(boolean status) {
        try {
            super.setPrimaryHDU(status);
        }
        catch (FitsException e) {
            System.err.println("Impossible exception in ImageData");
        }
        if (status) {
            this.myHeader.setSimple(true);
        } else {
            this.myHeader.setXtension("IMAGE");
        }
    }

    public static boolean isHeader(Header hdr) {
        String s;
        boolean found = false;
        found = hdr.getBooleanValue("SIMPLE");
        if (!found && (s = hdr.getStringValue("XTENSION")) != null && (s.trim().equals("IMAGE") || s.trim().equals("IUEIMAGE"))) {
            found = true;
        }
        if (!found) {
            return false;
        }
        return !hdr.getBooleanValue("GROUPS");
    }

    public static boolean isData(Object o) {
        int i;
        String s = o.getClass().getName();
        for (i = 0; i < s.length() && s.charAt(i) == '['; ++i) {
        }
        return i > 0 && s.charAt(i) != 'L' && s.charAt(i) != 'Z';
    }

    public Data manufactureData() throws FitsException {
        return ImageHDU.manufactureData(this.myHeader);
    }

    public static Data manufactureData(Header hdr) throws FitsException {
        return new ImageData(hdr);
    }

    public static Header manufactureHeader(Data d) throws FitsException {
        if (d == null) {
            return null;
        }
        Header h = new Header();
        d.fillHeader(h);
        return h;
    }

    public static Data encapsulate(Object o) throws FitsException {
        return new ImageData(o);
    }

    public ImageTiler getTiler() {
        return ((ImageData)this.myData).getTiler();
    }

    public void info() {
        if (ImageHDU.isHeader(this.myHeader)) {
            System.out.println("  Image");
        } else {
            System.out.println("  Image (bad header)");
        }
        System.out.println("      Header Information:");
        System.out.println("         BITPIX=" + this.myHeader.getIntValue("BITPIX", -1));
        int naxis = this.myHeader.getIntValue("NAXIS", -1);
        System.out.println("         NAXIS=" + naxis);
        for (int i = 1; i <= naxis; ++i) {
            System.out.println("         NAXIS" + i + "=" + this.myHeader.getIntValue("NAXIS" + i, -1));
        }
        System.out.println("      Data information:");
        try {
            if (this.myData.getData() == null) {
                System.out.println("        No Data");
            } else {
                System.out.println("         " + ArrayFuncs.arrayDescription(this.myData.getData()));
            }
        }
        catch (Exception e) {
            System.out.println("      Unable to get data");
        }
    }
}

