/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container.archive;

import alma.ArchiveIdentifierError.wrappers.AcsJIdentifierUnexpectedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeExhaustedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeLockedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeUnlockedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJUidAlreadyExistsEx;
import alma.archive.range.IdentifierRange;
import alma.archive.range.RangeT;
import alma.entities.commonentity.EntityRefT;
import alma.entities.commonentity.EntityT;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicLong;

public class Range {
    private final String archiveid;
    private final boolean isLocked;
    private final String rangeid;
    private final AtomicLong documentid;
    private final long minDocumentid;
    private final long maxDocumentid;

    public Range(IdentifierRange identifierRange) {
        this.archiveid = identifierRange.getArchiveID();
        this.isLocked = identifierRange.getIsLocked();
        RangeT r = identifierRange.getRange();
        this.rangeid = r.getRangeID();
        String baseid = r.getBaseDocumentID();
        this.minDocumentid = Long.parseLong(baseid, 16);
        this.documentid = new AtomicLong(this.minDocumentid);
        String maxid = r.getMaxDocumentID();
        this.maxDocumentid = maxid != null ? Long.parseLong(maxid, 16) : Long.MAX_VALUE;
    }

    public long getLength() {
        return this.maxDocumentid - this.minDocumentid + 1L;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void assignUniqueEntityId(EntityT entity) throws AcsJUidAlreadyExistsEx, AcsJRangeLockedEx, AcsJRangeExhaustedEx {
        this.setUniqueEntityId(entity, false);
    }

    public void replaceUniqueEntityId(EntityT entity) throws AcsJUidAlreadyExistsEx, AcsJRangeLockedEx, AcsJRangeExhaustedEx {
        this.setUniqueEntityId(entity, true);
    }

    private void setUniqueEntityId(EntityT entity, boolean allowReplacing) throws AcsJUidAlreadyExistsEx, AcsJRangeLockedEx, AcsJRangeExhaustedEx {
        if (entity == null) {
            throw new NullPointerException("argument 'entity' must not be null.");
        }
        if (!this.isLocked) {
            if (entity.getEntityId() != null && entity.getEntityId().length() > 0 && !allowReplacing) {
                AcsJUidAlreadyExistsEx ex = new AcsJUidAlreadyExistsEx();
                ex.setObjectDesc("Entity " + entity.getEntityTypeName());
                ex.setUid(entity.getEntityId());
                throw ex;
            }
        } else {
            AcsJRangeLockedEx ex = new AcsJRangeLockedEx();
            ex.setRange(this.rangeIdString());
            throw ex;
        }
        String uid = this.getNextID();
        entity.setEntityId(uid);
        entity.setEntityIdEncrypted("-- id encryption not yet implemented --");
    }

    public void assignUniqueEntityRef(EntityRefT ref) throws AcsJRangeUnlockedEx, AcsJRangeExhaustedEx {
        if (!this.isLocked) {
            AcsJRangeUnlockedEx ex = new AcsJRangeUnlockedEx();
            ex.setRange(this.rangeIdString());
            throw ex;
        }
        String uid = this.getNextID();
        ref.setEntityId(uid);
    }

    private String getNextID() throws AcsJRangeExhaustedEx {
        long nextID = this.documentid.getAndIncrement();
        if (nextID <= this.maxDocumentid) {
            return Range.generateUID(this.archiveid, this.rangeid, nextID);
        }
        this.documentid.decrementAndGet();
        AcsJRangeExhaustedEx ex = new AcsJRangeExhaustedEx();
        ex.setRange(this.rangeIdString());
        ex.setRangeMaxDocumentId("" + this.getMaxDocumentId());
        throw ex;
    }

    public static final String generateUID(String _archiveID, String _rangeID, long _localId) {
        String uid = "uid://" + _archiveID + "/X" + _rangeID + "/X" + Long.toHexString(_localId);
        return uid;
    }

    public boolean hasNextID() {
        return this.documentid.get() < this.maxDocumentid;
    }

    long getMaxDocumentId() {
        return this.maxDocumentid;
    }

    public URI next() throws AcsJIdentifierUnexpectedEx, AcsJRangeExhaustedEx {
        try {
            URI uri = new URI(this.getNextID());
            return uri;
        }
        catch (URISyntaxException e) {
            throw new AcsJIdentifierUnexpectedEx((Throwable)e);
        }
    }

    public URI rangeId() throws AcsJIdentifierUnexpectedEx {
        String uid = this.rangeIdString();
        try {
            URI uri = new URI(uid);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new AcsJIdentifierUnexpectedEx((Throwable)e);
        }
    }

    public final String rangeIdString() {
        String uid = "uid://" + this.archiveid + "/X" + this.rangeid + "/X0";
        return uid;
    }
}

