/*
 * Decompiled with CFR 0.152.
 */
package skyview.vo;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import skyview.executive.Settings;
import skyview.vo.ConeQualifier;

public class ConeQuerier
implements Runnable {
    private int nCol = 0;
    private int raCol = -1;
    private int decCol = -1;
    private int idCol = -1;
    private int currCol = -1;
    private int[] addCols = new int[0];
    private String[] addColNames;
    private static final int MAX_COL = 1024;
    private double size;
    private String tableID;
    private int entriesUsed = 0;
    private String finishMessage = "Finished";
    private String urlString;
    private boolean[] useFlags;
    private ArrayList<double[]> positions = new ArrayList();
    private ArrayList<String> ids = new ArrayList();
    private ArrayList<String[]> extraCols;
    private ArrayList<ConeQualifier> qualifiers = new ArrayList();
    private boolean criteria = false;
    private boolean criteriaMet;
    private PrintStream output = null;

    public ConeQuerier(String baseURL, String id, double ra, double dec, double size) {
        this(ConeQuerier.checkURLEnd(baseURL) + "RA=" + ra + "&DEC=" + dec + "&SR=" + size, id);
        this.size = size;
        this.tableID = id;
    }

    public ConeQuerier(String URL2, String id) {
        this.urlString = URL2;
        this.tableID = id;
        this.size = -1.0;
        if (Settings.has("CatalogColumns")) {
            this.addColNames = Settings.getArray("CatalogColumns");
            this.addCols = new int[this.addColNames.length];
            Arrays.fill(this.addCols, -1);
            this.extraCols = new ArrayList();
        }
    }

    public static String checkURLEnd(String url) {
        char last = url.charAt(url.length() - 1);
        if (last == '&' || last == '?') {
            return url;
        }
        if (url.indexOf("?") > 0) {
            return url + "&";
        }
        return url + "?";
    }

    public void setEntriesUsed(int n) {
        this.entriesUsed = n;
    }

    public void setOutput(PrintStream str) {
        this.output = str;
    }

    public void addCriterion(String name, String op, String value) {
        if (!this.criteria) {
            this.criteria = true;
            this.useFlags = new boolean[1024];
            Arrays.fill(this.useFlags, false);
        }
        this.qualifiers.add(new ConeQualifier(name, op, value));
    }

    public double getSize() {
        return this.size;
    }

    @Override
    public void run() {
        try {
            int len;
            BufferedInputStream bi = new BufferedInputStream(new URL(this.urlString).openStream());
            ByteArrayOutputStream bo = new ByteArrayOutputStream(32768);
            byte[] buf = new byte[32768];
            while ((len = bi.read(buf)) > 0) {
                bo.write(buf, 0, len);
            }
            bi.close();
            bo.close();
            String response = bo.toString();
            response = response.replaceAll("<!DOCTYPE.*", "");
            ByteArrayInputStream byi = new ByteArrayInputStream(response.getBytes());
            try {
                SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
                sp.parse((InputStream)byi, (DefaultHandler)new ConeQuerierCallBack());
            }
            catch (Error e) {
                if (!e.getMessage().equals(this.finishMessage)) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw new Error("Error parsing ConeQuery:" + e);
            }
        }
        catch (Exception e) {
            throw new Error("Unable to do IO in ConeQuery processing:" + e);
        }
    }

    public double[][] getPositions() {
        return (double[][])this.positions.toArray((T[])new double[0][]);
    }

    public String[] getIDs() {
        return this.ids.toArray(new String[0]);
    }

    public int getCount() {
        return this.positions.size();
    }

    public String getURL() {
        return this.urlString;
    }

    public ArrayList<String[]> getExtras() {
        return this.extraCols;
    }

    public String[] getExtraNames() {
        return this.addColNames;
    }

    public static ConeQuerier factory(String id, double ra, double dec, double size) {
        String xid = id.toLowerCase();
        String baseURL = xid.equals("ned") ? "http://nedwww.ipac.caltech.edu/cgi-bin/nph-NEDobjsearch?search_type=Near+Position+Search&of=xml_main&" : (xid.equals("simbad") ? "http://simbad.u-strasbg.fr/simbad-conesearch.pl?" : (xid.indexOf("/") > 0 ? "http://vizier.u-strasbg.fr/viz-bin/votable/-dtd/-A?-out.add=_RAJ2000,_DEJ2000&-source=" + id + "&" : "http://heasarc.gsfc.nasa.gov/cgi-bin/vo/cone/coneGet.pl?table=" + xid + "&"));
        return new ConeQuerier(baseURL, id, ra, dec, size);
    }

    public static void main(String[] args) throws Exception {
        String id = args[0];
        double ra = Double.parseDouble(args[1]);
        double dec = Double.parseDouble(args[2]);
        double size = Double.parseDouble(args[3]);
        ConeQuerier cq = ConeQuerier.factory(id, ra, dec, size);
        cq.setOutput(System.out);
        for (int i = 4; i < args.length; ++i) {
            String[] fields = args[i].split(",");
            System.out.println("Fields are:" + fields.length);
            cq.addCriterion(fields[0], fields[1], fields[2]);
        }
        cq.run();
        double[][] ps = cq.getPositions();
        String[] ids = cq.getIDs();
        for (int i = 0; i < ps.length; ++i) {
            System.out.println(ids[i] + ":" + ps[i][0] + "," + ps[i][1]);
        }
    }

    public void updateHeader(Header hdr) {
        try {
            hdr.insertHistory("Catalog: " + this.tableID + "  number of entries found:" + this.entriesUsed);
        }
        catch (FitsException e) {
            System.err.println("Error updating FITS header in CatalogQuerier:" + e);
        }
    }

    private class ConeQuerierCallBack
    extends DefaultHandler {
        private StringBuffer buf;
        private double ra = Double.NaN;
        private double dec = Double.NaN;
        String[] xcols = null;
        private String id = null;
        private boolean active = false;

        private ConeQuerierCallBack() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            block25: {
                block26: {
                    block24: {
                        if (!qName.equals("FIELD")) break block24;
                        String ucd = attrib.getValue("ucd");
                        if (ucd != null) {
                            if ((ucd = ucd.toLowerCase()).equals("pos_eq_ra_main") || ucd.equals("pos.eq.ra;meta.main")) {
                                ConeQuerier.this.raCol = ConeQuerier.this.nCol;
                            } else if (ucd.equals("pos_eq_dec_main") || ucd.equals("pos.eq.dec;meta.main")) {
                                ConeQuerier.this.decCol = ConeQuerier.this.nCol;
                            } else if (ucd.equals("id_main") || ucd.equals("meta.id;meta.main")) {
                                ConeQuerier.this.idCol = ConeQuerier.this.nCol;
                            }
                        }
                        String name = attrib.getValue("name");
                        if (ConeQuerier.this.output != null && name != null) {
                            ConeQuerier.this.output.print("Table: " + ConeQuerier.this.tableID + " Field:" + name + "\n      ");
                            if (attrib.getValue("datatype") != null) {
                                ConeQuerier.this.output.print("type:" + attrib.getValue("datatype"));
                            }
                            if (attrib.getValue("arraysize") != null) {
                                ConeQuerier.this.output.print("[" + attrib.getValue("arraysize") + "]");
                            }
                            if (attrib.getValue("ucd") != null) {
                                ConeQuerier.this.output.print(" UCD:" + attrib.getValue("ucd"));
                            }
                            if (attrib.getValue("unit") != null) {
                                ConeQuerier.this.output.print(" units:" + attrib.getValue("unit"));
                            }
                            ConeQuerier.this.output.println("");
                        }
                        if ((ConeQuerier.this.criteria || ConeQuerier.this.addCols.length > 0) && name != null) {
                            int i;
                            for (i = 0; i < ConeQuerier.this.qualifiers.size(); ++i) {
                                if (!((ConeQualifier)ConeQuerier.this.qualifiers.get(i)).getName().equals(name)) continue;
                                ((ConeQualifier)ConeQuerier.this.qualifiers.get(i)).setColumnType(ConeQuerier.this.nCol, attrib.getValue("datatype"));
                                if (ConeQuerier.this.nCol >= 1024) {
                                    System.err.println("Number of columns exceeds maximum for qualified query (1024) for table " + ConeQuerier.this.tableID);
                                    throw new Error(ConeQuerier.this.finishMessage);
                                }
                                ((ConeQuerier)ConeQuerier.this).useFlags[((ConeQuerier)ConeQuerier.this).nCol] = true;
                            }
                            for (i = 0; i < ConeQuerier.this.addCols.length; ++i) {
                                if (!ConeQuerier.this.addColNames[i].equals(name)) continue;
                                ((ConeQuerier)ConeQuerier.this).addCols[i] = ConeQuerier.this.nCol;
                            }
                        }
                        if (name != null && name.equals("name") && ConeQuerier.this.idCol == 0) {
                            ConeQuerier.this.idCol = ConeQuerier.this.nCol;
                        }
                        ConeQuerier.this.nCol += 1;
                        break block25;
                    }
                    if (!qName.equals("TR")) break block26;
                    ConeQuerier.this.currCol = 0;
                    ConeQuerier.this.criteriaMet = true;
                    if (ConeQuerier.this.addCols.length <= 0) break block25;
                    this.xcols = new String[ConeQuerier.this.addCols.length];
                    break block25;
                }
                if (qName.equals("TD")) {
                    if (ConeQuerier.this.currCol == ConeQuerier.this.raCol || ConeQuerier.this.currCol == ConeQuerier.this.decCol || ConeQuerier.this.currCol == ConeQuerier.this.idCol || ConeQuerier.this.criteria && ConeQuerier.this.useFlags[ConeQuerier.this.currCol]) {
                        this.active = true;
                        this.buf = new StringBuffer();
                    } else {
                        for (int i = 0; i < ConeQuerier.this.addCols.length; ++i) {
                            if (ConeQuerier.this.currCol != ConeQuerier.this.addCols[i]) continue;
                            this.active = true;
                            this.buf = new StringBuffer();
                        }
                    }
                } else if (ConeQuerier.this.criteria && qName.equals("TABLEDATA")) {
                    for (int i = 0; i < ConeQuerier.this.qualifiers.size(); ++i) {
                        if (((ConeQualifier)ConeQuerier.this.qualifiers.get(i)).getColumn() >= 0) continue;
                        System.err.println("Warning: Table " + ConeQuerier.this.tableID + " does not have qualified column '" + ((ConeQualifier)ConeQuerier.this.qualifiers.get(i)).getName() + "'\nTable not queried.");
                        if (ConeQuerier.this.output != null) {
                            ConeQuerier.this.output.println("Warning: Table " + ConeQuerier.this.tableID + " does not have qualified column '" + ((ConeQualifier)ConeQuerier.this.qualifiers.get(i)).getName() + "'\nTable not queried.");
                        }
                        throw new Error(ConeQuerier.this.finishMessage);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.active) {
                this.active = false;
                String s = new String(this.buf).trim();
                if (ConeQuerier.this.currCol == ConeQuerier.this.raCol) {
                    try {
                        this.ra = Double.parseDouble(s);
                    }
                    catch (Exception e) {
                        this.ra = Double.NaN;
                    }
                } else if (ConeQuerier.this.currCol == ConeQuerier.this.decCol) {
                    try {
                        this.dec = Double.parseDouble(s);
                    }
                    catch (Exception e) {
                        this.dec = Double.NaN;
                    }
                } else if (ConeQuerier.this.currCol == ConeQuerier.this.idCol) {
                    this.id = s;
                } else {
                    for (int i = 0; i < ConeQuerier.this.addCols.length; ++i) {
                        if (ConeQuerier.this.currCol != ConeQuerier.this.addCols[i]) continue;
                        this.xcols[i] = s;
                        break;
                    }
                }
                if (ConeQuerier.this.criteria && ConeQuerier.this.useFlags[ConeQuerier.this.currCol]) {
                    for (int i = 0; i < ConeQuerier.this.qualifiers.size() && ConeQuerier.this.criteriaMet; ++i) {
                        if (((ConeQualifier)ConeQuerier.this.qualifiers.get(i)).getColumn() != ConeQuerier.this.currCol) continue;
                        ConeQuerier.this.criteriaMet = ((ConeQualifier)ConeQuerier.this.qualifiers.get(i)).check(s);
                    }
                }
            }
            if (qName.equals("TD")) {
                ConeQuerier.this.currCol += 1;
            } else if (qName.equals("TR")) {
                if (ConeQuerier.this.criteriaMet && !Double.isNaN(this.ra) && !Double.isNaN(this.dec)) {
                    ConeQuerier.this.positions.add(new double[]{this.ra, this.dec});
                    ConeQuerier.this.ids.add(this.id);
                    if (ConeQuerier.this.addCols.length > 0) {
                        ConeQuerier.this.extraCols.add(this.xcols);
                    }
                }
            } else if (qName.equals("RESOURCE")) {
                throw new Error(ConeQuerier.this.finishMessage);
            }
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }
}

