/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.util.Base64InputStream;
import uk.ac.starlink.votable.Decoder;

class BinaryRowSequence
implements RowSequence {
    private final PushbackInputStream pIn_;
    private final DataInput dataIn_;
    private final Decoder[] decoders_;
    private final int ncol_;
    private Object[] row_;

    public BinaryRowSequence(Decoder[] decoders, InputStream in, String encoding) throws IOException {
        this.decoders_ = decoders;
        this.ncol_ = this.decoders_.length;
        if ("gzip".equals(encoding)) {
            in = new GZIPInputStream(in);
        } else if ("base64".equals(encoding)) {
            in = new Base64InputStream(in);
        }
        this.pIn_ = new PushbackInputStream(in);
        this.dataIn_ = new DataInputStream(this.pIn_);
    }

    public BinaryRowSequence(Decoder[] decoders, InputStream in) throws IOException {
        this(decoders, in, null);
    }

    public boolean next() throws IOException {
        int b = this.pIn_.read();
        if (b < 0) {
            return false;
        }
        this.pIn_.unread(b);
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.decoders_[icol].decodeStream(this.dataIn_);
        }
        this.row_ = row;
        return true;
    }

    public Object[] getRow() {
        if (this.row_ != null) {
            return this.row_;
        }
        throw new IllegalStateException("No next() yet");
    }

    public Object getCell(int icol) {
        if (this.row_ != null) {
            return this.row_[icol];
        }
        throw new IllegalStateException("No next() yet");
    }

    public void close() throws IOException {
        this.pIn_.close();
    }
}

