/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.adapters;

import alma.acs.logging.AcsLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;

public class Log4jLogger
extends Logger {
    private final AcsLogger delegate;

    protected Log4jLogger(LoggerContext ctx, String name, MessageFactory messageFactory, AcsLogger delegate) {
        super(ctx, name, messageFactory);
        this.delegate = delegate;
        delegate.addLoggerClass(Log4jLogger.class);
    }

    public boolean isTraceEnabled() {
        return this.delegate.isLoggable(this.log4jLevelToJdkLevel(Level.TRACE));
    }

    public boolean isDebugEnabled() {
        return this.delegate.isLoggable(this.log4jLevelToJdkLevel(Level.DEBUG));
    }

    public boolean isInfoEnabled() {
        return this.delegate.isLoggable(this.log4jLevelToJdkLevel(Level.INFO));
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String msg, Throwable t) {
        if (this.delegate.isLoggable(this.log4jLevelToJdkLevel(level))) {
            this.logMessage(fqcn, level, marker, msg, t);
        }
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        this.delegate.log(this.log4jLevelToJdkLevel(level), message.getFormattedMessage(), t);
        super.logMessage(fqcn, level, marker, message, t);
    }

    protected void log(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable t) {
        this.delegate.log(this.log4jLevelToJdkLevel(level), message.getFormattedMessage(), t);
        super.log(level, marker, fqcn, location, message, t);
    }

    java.util.logging.Level log4jLevelToJdkLevel(Level level) {
        switch (level.getStandardLevel()) {
            case TRACE: {
                return java.util.logging.Level.FINEST;
            }
            case DEBUG: {
                return java.util.logging.Level.FINER;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case FATAL: {
                return java.util.logging.Level.SEVERE;
            }
        }
        return java.util.logging.Level.WARNING;
    }
}

