/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Settings {
    private static HashMap<String, String> single = new HashMap();
    private static HashMap<String, String> backup;
    private static Pattern comma;
    private static Pattern equal;

    static void initializeSettings() {
        String settingsFile = System.getenv("VO_SETTINGS");
        if (settingsFile == null) {
            settingsFile = "vo.settings";
        }
        Settings.updateFromFile(settingsFile);
    }

    static void updateFromFile(String settingsFile) {
        BufferedReader ir = null;
        try {
            FileInputStream is = new FileInputStream(settingsFile);
            ir = new BufferedReader(new InputStreamReader(is));
            Settings.readFile(ir);
        }
        catch (Exception e) {
            System.out.println("No settings found");
        }
    }

    static void readFile(BufferedReader ir) {
        try {
            String line;
            Pattern eq = Pattern.compile("=");
            while ((line = ir.readLine()) != null) {
                char first;
                if ((line = line.trim()).length() < 2 || line.charAt(0) == '#') continue;
                String[] parse = eq.split(line, 2);
                if (parse.length > 2) {
                    System.err.println("Unparseable line in input settings:\n   " + line);
                    continue;
                }
                String val = "1";
                if (parse.length == 2) {
                    val = parse[1];
                }
                if ((first = val.charAt(0)) == '$' && (val = System.getenv(val.substring(1))) == null) continue;
                Settings.put(parse[0], val);
            }
        }
        catch (Exception e) {
            System.err.println("Exception caught parsing settings:\n" + e);
        }
    }

    public static void addArgs(String[] args) {
        for (String arg : args) {
            String[] tokens;
            if (arg.charAt(arg.length() - 1) == '\r') {
                arg = arg.substring(0, arg.length() - 1);
            }
            if ((tokens = equal.split(arg, 2)).length == 2) {
                String key = tokens[0];
                Settings.put(key, tokens[1]);
                continue;
            }
            Settings.put(arg, "1");
        }
    }

    private Settings() {
    }

    public static String get(String key) {
        return single.get(key.toLowerCase());
    }

    public static String get(String key, String dft) {
        String gt = Settings.get(key);
        if (gt == null) {
            return dft;
        }
        return gt;
    }

    public static String[] getArray(String key) {
        String gt = Settings.get(key);
        if (gt == null) {
            return new String[0];
        }
        return comma.split(gt);
    }

    public static void put(String key, String value) {
        if (value != null && value.equals("null")) {
            single.remove(key.toLowerCase());
            return;
        }
        if (value == null) {
            value = "1";
        }
        if (value.length() > 1 && (value.charAt(0) == '\'' || value.charAt(0) == '\"')) {
            char last = value.charAt(value.length() - 1);
            if (value.charAt(0) == last) {
                value = value.substring(1, value.length() - 1);
            }
        }
        single.put(key.toLowerCase(), value);
    }

    public static void save() {
        backup = new HashMap();
        backup.putAll(single);
    }

    public static void add(String key, String value) {
        if (value == null) {
            if (!Settings.has(key)) {
                Settings.put(key, value);
            }
            return;
        }
        String[] oldVals = Settings.getArray(key);
        String newValue = "";
        String comma = "";
        for (int i = 0; i < oldVals.length; ++i) {
            if (oldVals[i].equals(value)) {
                return;
            }
            newValue = newValue + comma + oldVals[i];
            comma = ",";
        }
        newValue = newValue + comma + value;
        Settings.put(key, newValue);
    }

    public static boolean has(String key) {
        return single.containsKey(key.toLowerCase());
    }

    public static String[] getKeys() {
        return single.keySet().toArray(new String[0]);
    }

    public static void restore() {
        if (backup != null) {
            single = backup;
        } else {
            System.err.println("Attempt to restore Settings ignored: No previous state saved.");
        }
        backup = null;
    }

    static {
        comma = Pattern.compile(",");
        equal = Pattern.compile("=");
        Settings.initializeSettings();
    }
}

