/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;

public class BufferedFile
implements ArrayDataInput,
ArrayDataOutput,
RandomAccess {
    private int bufferOffset;
    private int bufferLength;
    private int bufferSize;
    private long primitiveArrayCount;
    private byte[] buffer;
    private RandomAccessFile raf;
    private long fileOffset;
    private boolean doingInput;

    public BufferedFile(String filename) throws IOException {
        this(filename, "r", 32768);
    }

    public BufferedFile(String filename, String mode) throws IOException {
        this(filename, mode, 32768);
    }

    public BufferedFile(File file) throws IOException {
        this(file, "r", 32768);
    }

    public BufferedFile(File file, String mode) throws IOException {
        this(file, mode, 32768);
    }

    public BufferedFile(String filename, String mode, int bufferSize) throws IOException {
        File file = new File(filename);
        this.initialize(file, mode, bufferSize);
    }

    public BufferedFile(File file, String mode, int bufferSize) throws IOException {
        this.initialize(file, mode, bufferSize);
    }

    protected void initialize(File file, String mode, int bufferSize) throws IOException {
        this.raf = new RandomAccessFile(file, mode);
        this.buffer = new byte[bufferSize];
        this.bufferOffset = 0;
        this.bufferLength = 0;
        this.fileOffset = 0L;
        this.bufferSize = bufferSize;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        this.checkBuffer(-1);
        int total = 0;
        while (len > 0) {
            if (this.bufferOffset < this.bufferLength) {
                int get = len;
                if (this.bufferOffset + get > this.bufferLength) {
                    get = this.bufferLength - this.bufferOffset;
                }
                System.arraycopy(this.buffer, this.bufferOffset, buf, offset, get);
                len -= get;
                this.bufferOffset += get;
                offset += get;
                total += get;
                continue;
            }
            try {
                if (len > this.bufferSize) {
                    this.checkBuffer(this.bufferSize);
                    continue;
                }
                this.checkBuffer(len);
            }
            catch (EOFException e) {
                if (this.bufferLength > 0) {
                    System.arraycopy(this.buffer, 0, buf, offset, this.bufferLength);
                    total += this.bufferLength;
                    this.bufferLength = 0;
                }
                if (total == 0) {
                    throw e;
                }
                return total;
            }
        }
        return total;
    }

    private void checkBuffer(int needBytes) throws IOException {
        if (!this.doingInput && this.bufferOffset > 0) {
            this.flush();
        }
        this.doingInput = true;
        if (this.bufferOffset + needBytes < this.bufferLength) {
            return;
        }
        int len = this.bufferLength - this.bufferOffset;
        this.fileOffset += (long)this.bufferOffset;
        if (len > 0) {
            System.arraycopy(this.buffer, this.bufferOffset, this.buffer, 0, len);
        }
        needBytes -= len;
        this.bufferLength = len;
        this.bufferOffset = 0;
        while (needBytes > 0) {
            len = this.raf.read(this.buffer, this.bufferLength, this.bufferSize - this.bufferLength);
            if (len < 0) {
                throw new EOFException();
            }
            needBytes -= len;
            this.bufferLength += len;
        }
    }

    public int read() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1];
    }

    @Override
    public long skip(long offset) throws IOException {
        if (offset > 0L && this.fileOffset + (long)this.bufferOffset + offset > this.raf.length()) {
            offset = this.raf.length() - this.fileOffset - (long)this.bufferOffset;
            this.seek(this.raf.length());
        } else if (this.fileOffset + (long)this.bufferOffset + offset < 0L) {
            offset = -(this.fileOffset + (long)this.bufferOffset);
            this.seek(0L);
        } else {
            this.seek(this.fileOffset + (long)this.bufferOffset + offset);
        }
        return offset;
    }

    @Override
    public void seek(long offsetFromStart) throws IOException {
        if (!this.doingInput) {
            this.flush();
        }
        if (this.fileOffset <= offsetFromStart && offsetFromStart < this.fileOffset + (long)this.bufferLength) {
            this.bufferOffset = (int)(offsetFromStart - this.fileOffset);
        } else {
            if (offsetFromStart < 0L) {
                offsetFromStart = 0L;
            }
            this.fileOffset = offsetFromStart;
            this.raf.seek(this.fileOffset);
            this.bufferLength = 0;
            this.bufferOffset = 0;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.convertToBoolean();
    }

    private boolean convertToBoolean() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1] == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1] | 0xFF;
    }

    @Override
    public int readInt() throws IOException {
        return this.convertToInt();
    }

    private int convertToInt() throws IOException {
        this.checkBuffer(4);
        int x = this.bufferOffset;
        int i = this.buffer[x] << 24 | (this.buffer[x + 1] & 0xFF) << 16 | (this.buffer[x + 2] & 0xFF) << 8 | this.buffer[x + 3] & 0xFF;
        this.bufferOffset += 4;
        return i;
    }

    @Override
    public short readShort() throws IOException {
        return this.convertToShort();
    }

    private short convertToShort() throws IOException {
        this.checkBuffer(2);
        short s = (short)(this.buffer[this.bufferOffset] << 8 | this.buffer[this.bufferOffset + 1] & 0xFF);
        this.bufferOffset += 2;
        return s;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return this.convertToChar();
    }

    private char convertToChar() throws IOException {
        this.checkBuffer(2);
        char c = (char)(this.buffer[this.bufferOffset] << 8 | this.buffer[this.bufferOffset + 1] & 0xFF);
        this.bufferOffset += 2;
        return c;
    }

    @Override
    public long readLong() throws IOException {
        return this.convertToLong();
    }

    private long convertToLong() throws IOException {
        this.checkBuffer(8);
        int x = this.bufferOffset;
        int i1 = this.buffer[x] << 24 | (this.buffer[x + 1] & 0xFF) << 16 | (this.buffer[x + 2] & 0xFF) << 8 | this.buffer[x + 3] & 0xFF;
        int i2 = this.buffer[x + 4] << 24 | (this.buffer[x + 5] & 0xFF) << 16 | (this.buffer[x + 6] & 0xFF) << 8 | this.buffer[x + 7] & 0xFF;
        this.bufferOffset += 8;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.convertToInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.convertToLong());
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(b, off, len) < len) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int toSkip) throws IOException {
        return (int)this.skipBytes((long)toSkip);
    }

    @Override
    public long skipBytes(long toSkip) throws IOException {
        if (this.skip(toSkip) < toSkip) {
            throw new EOFException();
        }
        return toSkip;
    }

    @Override
    public String readUTF() throws IOException {
        this.checkBuffer(-1);
        this.raf.seek(this.fileOffset + (long)this.bufferOffset);
        String utf = this.raf.readUTF();
        this.fileOffset = this.raf.getFilePointer();
        this.bufferLength = 0;
        this.bufferOffset = 0;
        return utf;
    }

    @Override
    public String readLine() throws IOException {
        this.checkBuffer(-1);
        this.raf.seek(this.fileOffset + (long)this.bufferOffset);
        String line = this.raf.readLine();
        this.fileOffset = this.raf.getFilePointer();
        this.bufferLength = 0;
        this.bufferOffset = 0;
        return line;
    }

    @Override
    public int readArray(Object o) throws IOException {
        return (int)this.readLArray(o);
    }

    @Override
    public long readLArray(Object o) throws IOException {
        this.primitiveArrayCount = 0L;
        return this.primitiveArrayRecurse(o);
    }

    protected long primitiveArrayRecurse(Object o) throws IOException {
        if (o == null) {
            return this.primitiveArrayCount;
        }
        String className = o.getClass().getName();
        if (className.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + className);
        }
        if (className.charAt(1) == '[') {
            for (int i = 0; i < ((Object[])o).length; ++i) {
                this.primitiveArrayRecurse(((Object[])o)[i]);
            }
        } else {
            switch (className.charAt(1)) {
                case 'Z': {
                    this.primitiveArrayCount += (long)this.read((boolean[])o, 0, ((boolean[])o).length);
                    break;
                }
                case 'B': {
                    int len = this.read((byte[])o, 0, ((byte[])o).length);
                    break;
                }
                case 'C': {
                    this.primitiveArrayCount += (long)this.read((char[])o, 0, ((char[])o).length);
                    break;
                }
                case 'S': {
                    this.primitiveArrayCount += (long)this.read((short[])o, 0, ((short[])o).length);
                    break;
                }
                case 'I': {
                    this.primitiveArrayCount += (long)this.read((int[])o, 0, ((int[])o).length);
                    break;
                }
                case 'J': {
                    this.primitiveArrayCount += (long)this.read((long[])o, 0, ((long[])o).length);
                    break;
                }
                case 'F': {
                    this.primitiveArrayCount += (long)this.read((float[])o, 0, ((float[])o).length);
                    break;
                }
                case 'D': {
                    this.primitiveArrayCount += (long)this.read((double[])o, 0, ((double[])o).length);
                    break;
                }
                case 'L': {
                    if (className.equals("[Ljava.lang.Object;")) {
                        for (int i = 0; i < ((Object[])o).length; ++i) {
                            this.primitiveArrayRecurse(((Object[])o)[i]);
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedFile.readPrimitiveArray: " + className);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + className);
                }
            }
        }
        return this.primitiveArrayCount;
    }

    @Override
    public int read(boolean[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(boolean[] b, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                b[i] = this.convertToBoolean();
            }
            return length;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 1);
        }
    }

    @Override
    public int read(short[] s) throws IOException {
        return this.read(s, 0, s.length);
    }

    @Override
    public int read(short[] s, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                s[i] = this.convertToShort();
            }
            return length * 2;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 2);
        }
    }

    @Override
    public int read(char[] c) throws IOException {
        return this.read(c, 0, c.length);
    }

    @Override
    public int read(char[] c, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                c[i] = this.convertToChar();
            }
            return length * 2;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 2);
        }
    }

    @Override
    public int read(int[] i) throws IOException {
        return this.read(i, 0, i.length);
    }

    @Override
    public int read(int[] i, int start, int length) throws IOException {
        int ii;
        try {
            for (ii = start; ii < start + length; ++ii) {
                i[ii] = this.convertToInt();
            }
            return length * 4;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, ii, 4);
        }
    }

    @Override
    public int read(long[] l) throws IOException {
        return this.read(l, 0, l.length);
    }

    @Override
    public int read(long[] l, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                l[i] = this.convertToLong();
            }
            return length * 8;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 8);
        }
    }

    @Override
    public int read(float[] f) throws IOException {
        return this.read(f, 0, f.length);
    }

    @Override
    public int read(float[] f, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                f[i] = Float.intBitsToFloat(this.convertToInt());
            }
            return length * 4;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 4);
        }
    }

    @Override
    public int read(double[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    @Override
    public int read(double[] d, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                d[i] = Double.longBitsToDouble(this.convertToLong());
            }
            return length * 8;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 8);
        }
    }

    private int eofCheck(EOFException e, int start, int index, int length) throws EOFException {
        if (start == index) {
            throw e;
        }
        return (index - start) * length;
    }

    private void needBuffer(int need) throws IOException {
        if (this.doingInput) {
            this.fileOffset += (long)this.bufferOffset;
            this.raf.seek(this.fileOffset);
            this.doingInput = false;
            this.bufferOffset = 0;
            this.bufferLength = 0;
        }
        if (this.bufferOffset + need >= this.bufferSize) {
            this.raf.write(this.buffer, 0, this.bufferOffset);
            this.fileOffset += (long)this.bufferOffset;
            this.bufferOffset = 0;
        }
    }

    @Override
    public void write(int buf) throws IOException {
        this.convertFromByte(buf);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        if (length < this.bufferSize) {
            this.needBuffer(length);
            System.arraycopy(buf, offset, this.buffer, this.bufferOffset, length);
            this.bufferOffset += length;
        } else {
            this.flush();
            this.raf.write(buf, offset, length);
            this.fileOffset += (long)length;
            this.doingInput = false;
            this.bufferOffset = 0;
            this.bufferLength = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.doingInput && this.bufferOffset > 0) {
            this.raf.write(this.buffer, 0, this.bufferOffset);
            this.fileOffset += (long)this.bufferOffset;
            this.bufferOffset = 0;
            this.bufferLength = 0;
        }
    }

    protected void finalize() {
        try {
            if (this.getFD().valid()) {
                this.flush();
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.convertFromBoolean(b);
    }

    private void convertFromBoolean(boolean b) throws IOException {
        this.needBuffer(1);
        this.buffer[this.bufferOffset] = b ? (byte)1 : 0;
        ++this.bufferOffset;
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.convertFromByte(b);
    }

    private void convertFromByte(int b) throws IOException {
        this.needBuffer(1);
        this.buffer[this.bufferOffset++] = (byte)b;
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.convertFromInt(i);
    }

    private void convertFromInt(int i) throws IOException {
        this.needBuffer(4);
        this.buffer[this.bufferOffset++] = (byte)(i >>> 24);
        this.buffer[this.bufferOffset++] = (byte)(i >>> 16);
        this.buffer[this.bufferOffset++] = (byte)(i >>> 8);
        this.buffer[this.bufferOffset++] = (byte)i;
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.convertFromShort(s);
    }

    private void convertFromShort(int s) throws IOException {
        this.needBuffer(2);
        this.buffer[this.bufferOffset++] = (byte)(s >>> 8);
        this.buffer[this.bufferOffset++] = (byte)s;
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.convertFromChar(c);
    }

    private void convertFromChar(int c) throws IOException {
        this.needBuffer(2);
        this.buffer[this.bufferOffset++] = (byte)(c >>> 8);
        this.buffer[this.bufferOffset++] = (byte)c;
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.convertFromLong(l);
    }

    private void convertFromLong(long l) throws IOException {
        this.needBuffer(8);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 56);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 48);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 40);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 32);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 24);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 16);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 8);
        this.buffer[this.bufferOffset++] = (byte)l;
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.convertFromInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.convertFromLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes(), 0, s.length());
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.convertFromChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.flush();
        this.raf.writeUTF(s);
        this.fileOffset = this.raf.getFilePointer();
    }

    @Override
    public void writeArray(Object o) throws IOException {
        String className = o.getClass().getName();
        if (className.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedFile.writeArray:" + className);
        }
        if (className.charAt(1) == '[') {
            for (int i = 0; i < ((Object[])o).length; ++i) {
                this.writeArray(((Object[])o)[i]);
            }
        } else {
            switch (className.charAt(1)) {
                case 'Z': {
                    this.write((boolean[])o, 0, ((boolean[])o).length);
                    break;
                }
                case 'B': {
                    this.write((byte[])o, 0, ((byte[])o).length);
                    break;
                }
                case 'C': {
                    this.write((char[])o, 0, ((char[])o).length);
                    break;
                }
                case 'S': {
                    this.write((short[])o, 0, ((short[])o).length);
                    break;
                }
                case 'I': {
                    this.write((int[])o, 0, ((int[])o).length);
                    break;
                }
                case 'J': {
                    this.write((long[])o, 0, ((long[])o).length);
                    break;
                }
                case 'F': {
                    this.write((float[])o, 0, ((float[])o).length);
                    break;
                }
                case 'D': {
                    this.write((double[])o, 0, ((double[])o).length);
                    break;
                }
                case 'L': {
                    if (className.equals("[Ljava.lang.String;")) {
                        this.write((String[])o, 0, ((String[])o).length);
                        break;
                    }
                    if (className.equals("[Ljava.lang.Object;")) {
                        for (int i = 0; i < ((Object[])o).length; ++i) {
                            this.writeArray(((Object[])o)[i]);
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedFile.write: " + className);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedFile.write: " + className);
                }
            }
        }
    }

    @Override
    public void write(boolean[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(boolean[] b, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.convertFromBoolean(b[i]);
        }
    }

    @Override
    public void write(short[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(short[] s, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.convertFromShort(s[i]);
        }
    }

    @Override
    public void write(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.convertFromChar(c[i]);
        }
    }

    @Override
    public void write(int[] i) throws IOException {
        this.write(i, 0, i.length);
    }

    @Override
    public void write(int[] i, int start, int length) throws IOException {
        for (int ii = start; ii < start + length; ++ii) {
            this.convertFromInt(i[ii]);
        }
    }

    @Override
    public void write(long[] l) throws IOException {
        this.write(l, 0, l.length);
    }

    @Override
    public void write(long[] l, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.convertFromLong(l[i]);
        }
    }

    @Override
    public void write(float[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    @Override
    public void write(float[] f, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.convertFromInt(Float.floatToIntBits(f[i]));
        }
    }

    @Override
    public void write(double[] d) throws IOException {
        this.write(d, 0, d.length);
    }

    @Override
    public void write(double[] d, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.convertFromLong(Double.doubleToLongBits(d[i]));
        }
    }

    @Override
    public void write(String[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(String[] s, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.writeBytes(s[i]);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.raf.close();
    }

    public FileDescriptor getFD() throws IOException {
        return this.raf.getFD();
    }

    public FileChannel getChannel() {
        return this.raf.getChannel();
    }

    public long length() throws IOException {
        this.flush();
        return this.raf.length();
    }

    @Override
    public long getFilePointer() {
        return this.fileOffset + (long)this.bufferOffset;
    }

    public void setLength(long newLength) throws IOException {
        this.flush();
        this.raf.setLength(newLength);
        if (newLength < this.fileOffset) {
            this.fileOffset = newLength;
        }
    }
}

