/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.executive.Settings;
import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;
import skyview.geometry.Util;
import skyview.geometry.projecter.OctaStraddle;
import skyview.geometry.projecter.Straddle;

public class Toa
extends Projecter {
    private static final double MIN_DELTA = 1.0E-10;
    private double minDelta = 1.0E-10;
    private static final double gEPSILON = 1.0E-20;
    private double epsilon = 1.0E-20;
    private Straddle myStraddler = new OctaStraddle(1.5707963267948966, this);
    private static final double RSCALE = 1.5707963267948966;
    private static double[][][] quadrantRotation = new double[][][]{new double[][]{{1.0, 0.0}, {0.0, 1.0}}, new double[][]{{0.0, -1.0}, {1.0, 0.0}}, new double[][]{{-1.0, 0.0}, {0.0, -1.0}}, new double[][]{{0.0, 1.0}, {-1.0, 0.0}}};
    private static double[][] posTriOffsets = new double[][]{{0.0, 1.0}, {0.0, 0.0}, {1.0, 0.0}, {0.0, 0.0}};
    private static double[][] negTriOffsets = new double[][]{{1.0, 1.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private int gridLevel = -1;
    private int gridX = 0;
    private int gridY = 0;
    private int gridSub = 0;
    private double gridDelta;
    private double gridOffX;
    private double gridOffY;
    private double nPix;
    private double[][][] gridValues;
    private double[] vec = new double[2];
    private double[] tpos = new double[2];
    private boolean diagonal;
    private double[] result = new double[2];
    double[] copy = new double[3];
    double[][] temp = new double[4][3];
    double[] diagTem = new double[3];

    public Toa() {
        if (Settings.has("ToastGrid")) {
            String[] params = Settings.getArray("ToastGrid");
            this.gridLevel = Integer.parseInt(params[0]);
            this.gridX = Integer.parseInt(params[1]);
            this.gridY = Integer.parseInt(params[2]);
            this.gridSub = params.length < 4 ? 8 : Integer.parseInt(params[3]);
            double nTile = Math.pow(2.0, this.gridLevel);
            this.gridOffX = ((double)(2 * this.gridX) - nTile) / nTile;
            this.gridOffY = ((double)(2 * this.gridY) - nTile) / nTile;
            this.nPix = Math.pow(2.0, this.gridSub) + 1.0;
            this.gridDelta = 2.0 / Math.pow(2.0, this.gridLevel + this.gridSub);
            this.gridValues = this.tile(this.gridLevel, this.gridX, this.gridY, this.gridSub);
        }
    }

    @Override
    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && Math.abs(plane[0]) <= 1.5707963267948966 && Math.abs(plane[1]) <= 1.5707963267948966;
    }

    public void setPrecision(double epsilon, double minDelta) {
        this.epsilon = epsilon;
        this.minDelta = minDelta;
    }

    public double[] project(double lon, double lat) {
        boolean dir;
        while (Math.abs(lat) > 1.5707963267948966) {
            if (lat > 1.5707963267948966) {
                lat = Math.PI - lat;
            }
            if (lat < -1.5707963267948966) {
                lat = -Math.PI - lat;
            }
            lon += Math.PI;
        }
        while (lon < 0.0) {
            lon += Math.PI * 2;
        }
        while (lon >= Math.PI * 2) {
            lon -= Math.PI * 2;
        }
        int square = (int)(2.0 * lon / Math.PI) % 4;
        double offset = Math.PI * (double)square / 2.0;
        lon -= offset;
        boolean bl = dir = lat >= 0.0;
        if (!dir) {
            lat = Math.abs(lat);
        }
        double[] pos = this.find(lon, lat);
        if (!dir) {
            double x = 1.0 - pos[1];
            double y = 1.0 - pos[0];
            pos[0] = x;
            pos[1] = y;
        }
        double[][] qr = quadrantRotation[square];
        this.tpos[0] = pos[0] * qr[0][0] + pos[1] * qr[0][1];
        this.tpos[1] = pos[0] * qr[1][0] + pos[1] * qr[1][1];
        return this.tpos;
    }

    public double[] find(double lon, double lat) {
        double[] unit = new double[]{Math.cos(lon) * Math.cos(lat), Math.sin(lon) * Math.cos(lat), Math.sin(lat)};
        this.transform(unit, this.result);
        return this.result;
    }

    @Override
    public String getName() {
        return "Toa";
    }

    @Override
    public String getDescription() {
        return "Projection based on HTM pixelization of sky";
    }

    @Override
    public boolean isInverse(Transformer obj) {
        return obj instanceof ToaDeproj;
    }

    @Override
    public Deprojecter inverse() {
        return new ToaDeproj();
    }

    @Override
    public void transform(double[] unit, double[] plane) {
        System.arraycopy(unit, 0, this.copy, 0, 3);
        boolean dir = true;
        double delta = 1.0;
        double signx = 1.0;
        double signy = 1.0;
        if (this.copy[0] < 0.0) {
            this.copy[0] = -this.copy[0];
            signx = -1.0;
        }
        if (this.copy[1] < 0.0) {
            this.copy[1] = -this.copy[1];
            signy = -1.0;
        }
        boolean flipped = false;
        if (this.copy[2] < 0.0) {
            this.copy[2] = -this.copy[2];
            flipped = true;
        }
        plane[0] = 0.0;
        plane[1] = 0.0;
        Object vectors = dir ? new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}} : new double[][]{{0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}};
        boolean loop = false;
        while (delta > this.minDelta) {
            double[][] midpoints = new double[3][3];
            delta /= 2.0;
            int fragment = this.findTriangle(this.copy, (double[][])vectors, midpoints);
            if (dir) {
                plane[0] = plane[0] + delta * posTriOffsets[fragment][0];
                plane[1] = plane[1] + delta * posTriOffsets[fragment][1];
            } else {
                plane[0] = plane[0] + delta * negTriOffsets[fragment][0];
                plane[1] = plane[1] + delta * negTriOffsets[fragment][1];
            }
            if (fragment == 0) {
                vectors[1] = midpoints[0];
                vectors[2] = midpoints[2];
                continue;
            }
            if (fragment == 1) {
                vectors[0] = midpoints[0];
                vectors[2] = midpoints[1];
                continue;
            }
            if (fragment == 2) {
                vectors[0] = midpoints[2];
                vectors[1] = midpoints[1];
                continue;
            }
            if (dir) {
                vectors[0] = midpoints[2];
                vectors[1] = midpoints[0];
                vectors[2] = midpoints[1];
            } else {
                vectors = midpoints;
            }
            dir = !dir;
        }
        if (flipped) {
            double tmp = plane[0];
            plane[0] = 1.0 - plane[1];
            plane[1] = 1.0 - tmp;
        }
        plane[0] = plane[0] * (1.5707963267948966 * signx);
        plane[1] = 1.5707963267948966 * plane[1] * signy;
    }

    int findTriangle(double[] unit, double[][] vectors, double[][] midpoints) {
        this.midpoint(vectors[0], vectors[1], midpoints[0]);
        this.midpoint(vectors[1], vectors[2], midpoints[1]);
        this.midpoint(vectors[2], vectors[0], midpoints[2]);
        if (this.inside(unit, vectors[0], midpoints[0], midpoints[2])) {
            return 0;
        }
        if (this.inside(unit, midpoints[0], vectors[1], midpoints[1])) {
            return 1;
        }
        if (this.inside(unit, midpoints[2], midpoints[1], vectors[2])) {
            return 2;
        }
        return 3;
    }

    boolean inside(double[] p, double[] v1, double[] v2, double[] v3) {
        double[] crossp = new double[]{v1[1] * v2[2] - v2[1] * v1[2], v1[2] * v2[0] - v2[2] * v1[0], v1[0] * v2[1] - v2[0] * v1[1]};
        if (p[0] * crossp[0] + p[1] * crossp[1] + p[2] * crossp[2] < -this.epsilon) {
            return false;
        }
        crossp[0] = v2[1] * v3[2] - v3[1] * v2[2];
        crossp[1] = v2[2] * v3[0] - v3[2] * v2[0];
        crossp[2] = v2[0] * v3[1] - v3[0] * v2[1];
        if (p[0] * crossp[0] + p[1] * crossp[1] + p[2] * crossp[2] < -this.epsilon) {
            return false;
        }
        crossp[0] = v3[1] * v1[2] - v1[1] * v3[2];
        crossp[1] = v3[2] * v1[0] - v1[2] * v3[0];
        crossp[2] = v3[0] * v1[1] - v1[0] * v3[1];
        return !(p[0] * crossp[0] + p[1] * crossp[1] + p[2] * crossp[2] < -this.epsilon);
    }

    void midpoint(double[] v1, double[] v2, double[] w) {
        double x = v1[0] + v2[0];
        double y = v1[1] + v2[1];
        double z = v1[2] + v2[2];
        double tmp = Math.sqrt(x * x + y * y + z * z);
        w[0] = x / tmp;
        w[1] = y / tmp;
        w[2] = z / tmp;
    }

    public double[][][] tile(int level, int ix, int iy, int subdiv) {
        int dim = (int)Math.pow(2.0, subdiv);
        int d2 = dim / 2;
        double[][][] coords = new double[dim + 1][dim + 1][3];
        if (level > 0) {
            double[][] bounds = this.bounds(level, ix, iy);
            coords[dim][dim] = bounds[0];
            coords[0][dim] = bounds[1];
            coords[0][0] = bounds[2];
            coords[dim][0] = bounds[3];
            this.fill(coords, dim, 0, 0, dim, this.diagonal);
        } else {
            coords[0][0] = new double[]{0.0, 0.0, -1.0};
            coords[0][dim] = new double[]{0.0, 0.0, -1.0};
            coords[dim][0] = new double[]{0.0, 0.0, -1.0};
            coords[dim][dim] = new double[]{0.0, 0.0, -1.0};
            coords[d2][0] = new double[]{0.0, -1.0, 0.0};
            coords[0][d2] = new double[]{-1.0, 0.0, 0.0};
            coords[d2][dim] = new double[]{0.0, 1.0, 0.0};
            coords[dim][d2] = new double[]{1.0, 0.0, 0.0};
            coords[d2][d2] = new double[]{0.0, 0.0, 1.0};
            this.fill(coords, d2, 0, 0, d2, true);
            this.fill(coords, d2, 0, d2, d2, false);
            this.fill(coords, d2, d2, 0, d2, false);
            this.fill(coords, d2, d2, d2, d2, true);
        }
        return coords;
    }

    double[][] bounds(int level, int ix, int iy) {
        int pow = (int)Math.pow(2.0, level - 1);
        int tx = ix / pow;
        int ty = iy / pow;
        double[][] coords = tx == 0 && ty == 1 ? new double[][]{{0.0, 0.0, 1.0}, {-1.0, 0.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, -1.0, 0.0}} : (tx == 1 && ty == 1 ? new double[][]{{1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, -1.0}} : (tx == 0 && ty == 0 ? new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}, {-1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}} : new double[][]{{0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}}));
        this.diagonal = tx != ty;
        return this.bounds(coords, level - 1, ix % pow, iy % pow);
    }

    double[][] bounds(double[][] coords, int level, int x, int y) {
        if (level == 0) {
            return coords;
        }
        int pow = (int)Math.pow(2.0, level - 1);
        int tx = x / pow;
        int ty = y / pow;
        int ind = 0;
        ind = tx == 1 && ty == 0 ? 0 : (tx == 0 && ty == 0 ? 1 : (tx == 0 && ty == 1 ? 2 : 3));
        int diag = (ind + 2) % 4;
        if (this.diagonal) {
            this.midpoint(coords[1], coords[3], this.diagTem);
        } else {
            this.midpoint(coords[0], coords[2], this.diagTem);
        }
        for (int i = 0; i < 4; ++i) {
            if (i == ind || (i + ind) % 2 == 0) continue;
            this.midpoint(coords[ind], coords[i], coords[i]);
        }
        System.arraycopy(this.diagTem, 0, coords[diag], 0, this.diagTem.length);
        return this.bounds(coords, level - 1, x % pow, y % pow);
    }

    void fill(double[][][] coords, int len, int x0, int y0, int mx, boolean sinister) {
        int dim = len;
        while (dim > 1) {
            int dim2 = dim / 2;
            for (int i = y0 + dim2; i < y0 + mx; i += dim) {
                int ym = i - dim2;
                int yp = i + dim2;
                for (int j = x0 + dim2; j < x0 + mx; j += dim) {
                    int xm = j - dim2;
                    int xp = j + dim2;
                    this.midpoint(coords[ym][xm], coords[ym][xp], coords[ym][j]);
                    this.midpoint(coords[ym][xm], coords[yp][xm], coords[i][xm]);
                    this.midpoint(coords[yp][xm], coords[yp][xp], coords[yp][j]);
                    this.midpoint(coords[ym][xp], coords[yp][xp], coords[i][xp]);
                    if (sinister) {
                        this.midpoint(coords[yp][xm], coords[ym][xp], coords[i][j]);
                        continue;
                    }
                    this.midpoint(coords[ym][xm], coords[yp][xp], coords[i][j]);
                }
            }
            dim = dim2;
        }
    }

    public static void show(String prefix, double[] vector) {
        double[] coords = Util.coord(vector);
        System.out.printf("%s: %12.5f %12.5f (%9.5f %9.5f %9.5f)\n", prefix, Math.toDegrees(coords[0]), Math.toDegrees(coords[1]), vector[0], vector[1], vector[2]);
    }

    public static void main(String[] args) throws Exception {
        double[] unit = new double[3];
        double[] plane = new double[2];
        double ra = Math.toRadians(Double.parseDouble(args[0]));
        double dec = Math.toRadians(Double.parseDouble(args[1]));
        unit[2] = Math.sin(dec);
        unit[0] = Math.cos(ra) * Math.cos(dec);
        unit[1] = Math.sin(ra) * Math.cos(dec);
        Toa tp = new Toa();
        tp.transform(unit, plane);
        System.out.printf("%.6f,%.6f\n", plane[0] / 1.5707963267948966, plane[1] / 1.5707963267948966);
    }

    @Override
    public boolean straddleable() {
        return true;
    }

    @Override
    public double[] shadowPoint(double x, double y) {
        if (Math.abs(x) == Math.abs(y)) {
            return new double[]{x, y};
        }
        if (Math.abs(y) > Math.abs(x)) {
            if (y > 0.0) {
                return new double[]{x, Math.PI - y};
            }
            return new double[]{x, -Math.PI - y};
        }
        if (x > 0.0) {
            return new double[]{Math.PI - x, y};
        }
        return new double[]{-Math.PI - x, y};
    }

    @Override
    public boolean straddle(double[][] vertices) {
        return this.myStraddler.straddle(vertices);
    }

    @Override
    public double[][][] straddleComponents(double[][] vertices) {
        return this.myStraddler.straddleComponents(vertices);
    }

    public class ToaDeproj
    extends Deprojecter {
        double[] result = new double[3];

        @Override
        public String getName() {
            return "ToaDeproj";
        }

        @Override
        public String getDescription() {
            return "Deproject from the TOAST plane to the unit sphere";
        }

        @Override
        public boolean isInverse(Transformer obj) {
            return obj instanceof Toa;
        }

        @Override
        public Transformer inverse() {
            return Toa.this;
        }

        @Override
        public void transform(double[] plane, double[] sphere) {
            double[] res = this.deproject(plane[0] / 1.5707963267948966, plane[1] / 1.5707963267948966);
            System.arraycopy(res, 0, sphere, 0, res.length);
        }

        public double[] deproject(double x, double y) {
            boolean dir;
            Object vectors;
            if (Toa.this.gridLevel >= 0) {
                double tx = Math.floor((x -= Toa.this.gridOffX) / Toa.this.gridDelta + 0.5);
                double ty = Math.floor((y -= Toa.this.gridOffY) / Toa.this.gridDelta + 0.5);
                if (tx >= 0.0 && tx <= Toa.this.nPix && ty >= 0.0 && ty <= Toa.this.nPix) {
                    return Toa.this.gridValues[(int)tx][(int)ty];
                }
            }
            x = (x + 1.0) % 2.0 - 1.0;
            y = (y + 1.0) % 2.0 - 1.0;
            double signx = 1.0;
            double signy = 1.0;
            if (x < 0.0) {
                x = -x;
                signx = -1.0;
            }
            if (y < 0.0) {
                y = -y;
                signy = -1.0;
            }
            if (x + y > 1.0) {
                vectors = new double[][]{{0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}};
                dir = false;
            } else {
                vectors = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}};
                dir = true;
            }
            double delta = 1.0;
            double factor = 1.0;
            while (delta > Toa.this.minDelta) {
                delta /= 2.0;
                factor *= 2.0;
                x *= 2.0;
                y *= 2.0;
                double[][] midpoints = new double[3][3];
                Toa.this.midpoint(vectors[0], vectors[1], midpoints[0]);
                Toa.this.midpoint(vectors[1], vectors[2], midpoints[1]);
                Toa.this.midpoint(vectors[2], vectors[0], midpoints[2]);
                if (dir) {
                    if (y > 1.0) {
                        vectors[1] = midpoints[0];
                        vectors[2] = midpoints[2];
                        y -= 1.0;
                        continue;
                    }
                    if (x > 1.0) {
                        vectors[0] = midpoints[2];
                        vectors[1] = midpoints[1];
                        x -= 1.0;
                        continue;
                    }
                    if (x + y < 1.0) {
                        vectors[0] = midpoints[0];
                        vectors[2] = midpoints[1];
                        continue;
                    }
                    vectors[0] = midpoints[2];
                    vectors[1] = midpoints[0];
                    vectors[2] = midpoints[1];
                    dir = !dir;
                    continue;
                }
                if (x < 1.0) {
                    vectors[0] = midpoints[0];
                    vectors[2] = midpoints[1];
                    y -= 1.0;
                    continue;
                }
                if (y < 1.0) {
                    vectors[0] = midpoints[2];
                    vectors[1] = midpoints[1];
                    x -= 1.0;
                    continue;
                }
                if ((x -= 1.0) + (y -= 1.0) < 1.0) {
                    vectors = midpoints;
                    dir = !dir;
                    continue;
                }
                vectors[1] = midpoints[0];
                vectors[2] = midpoints[2];
            }
            double xs = vectors[0][0] + vectors[1][0] + vectors[2][0];
            double ys = vectors[0][1] + vectors[1][1] + vectors[2][1];
            double zs = vectors[0][2] + vectors[1][2] + vectors[2][2];
            double norm = Math.sqrt(xs * xs + ys * ys + zs * zs);
            double[] unit = new double[]{xs / norm, ys / norm, zs / norm};
            unit[0] = unit[0] * signx;
            unit[1] = unit[1] * signy;
            return unit;
        }
    }
}

