/*
 * Decompiled with CFR 0.152.
 */
package skyview.util;

import skyview.util.Scaler;

public class SqrtScaler
extends Scaler {
    private boolean scaleNegative = false;
    private double smallestPositive = -1.0;
    private double scale;
    private double min;

    public SqrtScaler() {
    }

    public SqrtScaler(double minVal, double maxVal, int minOutput, int maxOutput, boolean scaleNegative) {
        super(minVal, maxVal, minOutput, maxOutput);
        this.scaleNegative = scaleNegative;
    }

    @Override
    protected void prepareScaling(double[] c) {
        int i;
        if (this.scaleNegative && this.getMinVal() < 0.0) {
            double delta = this.getMinVal();
            i = 0;
            while (i < c.length) {
                int n = i++;
                c[n] = c[n] + delta;
            }
            this.setMinVal(this.getMinVal() + delta);
            this.setMaxVal(this.getMaxVal() + delta);
        }
        double smallestPositive = 1.0E300;
        if (this.getMinVal() >= 0.0) {
            smallestPositive = this.getMinVal();
        } else if (this.getMaxVal() >= 0.0) {
            for (i = 0; i < c.length; ++i) {
                if (!(c[i] >= 0.0) || !(c[i] < smallestPositive)) continue;
                smallestPositive = c[i];
            }
        }
        this.min = smallestPositive;
        if (this.min < this.getMaxVal()) {
            this.scale = (double)(this.getMaxOutput() - this.getMinOutput()) / Math.sqrt(this.getMaxVal() - Math.sqrt(smallestPositive));
        }
    }

    @Override
    protected byte scale(double val) {
        if (val <= this.min) {
            return (byte)this.getMinOutput();
        }
        return (byte)((Math.sqrt(val) - Math.sqrt(this.min)) * this.scale + (double)this.getMinOutput());
    }
}

