/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.SkyMatchEngine;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.ttools.join.HumanMatchEngine;
import uk.ac.starlink.ttools.join.Match2Mapping;

public class SkyMatch2Mapping
extends Match2Mapping {
    private static final Pattern RA_REGEX;
    private static final Pattern DEC_REGEX;
    private static final Logger logger_;
    static /* synthetic */ Class class$java$lang$Number;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SkyMatch2Mapping(SkyMatchEngine matcher, String raExpr1, String decExpr1, String raExpr2, String decExpr2, JoinType join, boolean bestOnly, JoinFixAction fixact1, JoinFixAction fixact2, ProgressIndicator progger) {
        super(new HumanMatchEngine((MatchEngine)matcher), new String[]{raExpr1, decExpr1}, new String[]{raExpr2, decExpr2}, join, bestOnly, fixact1, fixact2, new HumanMatchEngine((MatchEngine)matcher).getMatchScoreInfo(), progger);
    }

    protected StarTable makeSubTable(StarTable inTable, String[] exprTuple) throws ExecutionException {
        String decExpr;
        String raEx = exprTuple[0];
        String decEx = exprTuple[1];
        String raExpr = raEx == null || raEx.trim().length() == 0 ? SkyMatch2Mapping.guessDegreesExpression(inTable, "ra", RA_REGEX) : raEx;
        String string = decExpr = decEx == null || decEx.trim().length() == 0 ? SkyMatch2Mapping.guessDegreesExpression(inTable, "dec", DEC_REGEX) : decEx;
        if (raExpr == null || decExpr == null) {
            throw new ExecutionException("Failed to identify likely RA/DEC columns");
        }
        return super.makeSubTable(inTable, new String[]{raExpr, decExpr});
    }

    static String guessDegreesExpression(StarTable inTable, String ucdAtom, Pattern nameRegex) {
        double factor;
        String atom = ucdAtom.toLowerCase();
        String ucd1Part = "pos_eq_" + atom;
        String ucd1Full = ucd1Part + "_main";
        String ucd1pPart = "pos.eq." + atom;
        String ucd1pFull = ucd1pPart + ";meta.main";
        int bestIndex = -1;
        int score = 0;
        int ncol = inTable.getColumnCount();
        for (int i = 0; i < ncol; ++i) {
            ColumnInfo info;
            if (!(class$java$lang$Number == null ? SkyMatch2Mapping.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom((info = inTable.getColumnInfo(i)).getContentClass())) continue;
            String ucd = info.getUCD();
            String name = info.getName();
            if (ucd != null && ucd.length() > 0) {
                ucd = ucd.trim().toLowerCase();
                if (score < 20 && (ucd.equals(ucd1Full) || ucd.equals(ucd1pFull))) {
                    bestIndex = i;
                    score = 20;
                }
                if (score < 10 && (ucd.equals(ucd1Part) || ucd.equals(ucd1pPart))) {
                    bestIndex = i;
                    score = 10;
                }
            }
            if (name == null || name.length() <= 0 || score >= 5 || !nameRegex.matcher(name.trim()).matches()) continue;
            bestIndex = i;
            score = 5;
        }
        if (bestIndex < 0) {
            if (!$assertionsDisabled && score != 0) {
                throw new AssertionError();
            }
            return null;
        }
        ColumnInfo info = inTable.getColumnInfo(bestIndex);
        logger_.info("Identified column " + info + " as " + ucdAtom.toUpperCase());
        String units = info.getUnitString();
        if (units == null || units.trim().length() == 0) {
            logger_.info("No units listed for column " + info.getName() + " - assuming degrees");
            factor = 1.0;
        } else if (units.toLowerCase().startsWith("deg")) {
            factor = 1.0;
        } else if (units.toLowerCase().startsWith("rad")) {
            factor = 57.29577951308232;
        } else {
            logger_.info("Units for column " + info.getName() + " listed as " + units + " - assuming degrees");
            factor = 1.0;
        }
        String expr = "$" + (bestIndex + 1);
        if (factor != 1.0) {
            expr = factor + "*" + expr;
        }
        logger_.config(ucdAtom.toUpperCase() + ": " + expr);
        return expr;
    }

    static {
        $assertionsDisabled = !SkyMatch2Mapping.class.desiredAssertionStatus();
        try {
            RA_REGEX = Pattern.compile("RA_?J?(2000)?", 2);
            DEC_REGEX = Pattern.compile("DEC?L?_?J?(2000)?", 2);
        }
        catch (PatternSyntaxException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Bad pattern?"))).initCause(e);
        }
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");
    }
}

