/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import gnu.jel.CompilationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.BinnedData;
import uk.ac.starlink.ttools.plot.DataBounds;
import uk.ac.starlink.ttools.plot.Histogram;
import uk.ac.starlink.ttools.plot.HistogramPlotState;
import uk.ac.starlink.ttools.plot.MapBinnedData;
import uk.ac.starlink.ttools.plot.NormalisedBinnedData;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Rounder;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plottask.BarStyleFactory;
import uk.ac.starlink.ttools.plottask.CartesianTablePlotData;
import uk.ac.starlink.ttools.plottask.PlotStateFactory;
import uk.ac.starlink.ttools.plottask.StyleFactory;
import uk.ac.starlink.ttools.plottask.TablePlotData;

public class HistogramPlotStateFactory
extends PlotStateFactory {
    private final DoubleParameter yloParam_ = new DoubleParameter("ylo");
    private final DoubleParameter yhiParam_;
    private final BooleanParameter ylogParam_;
    private final DoubleParameter binwidthParam_;
    private final BooleanParameter normParam_;
    private final BooleanParameter cumulativeParam_;
    private final DoubleParameter binbaseParam_;
    private static final int DEFAULT_BINS = 20;
    private static final double PAD_RATIO = 0.01;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HistogramPlotStateFactory() {
        super(new String[]{"X"}, false, false, 0);
        this.yloParam_.setPrompt("Lower bound for Y axis");
        this.yloParam_.setDescription(new String[]{"<p>Lower bound for Y axis.", "</p>"});
        this.yloParam_.setDefault("0");
        this.yhiParam_ = new DoubleParameter("yhi");
        this.yhiParam_.setNullPermitted(true);
        this.yhiParam_.setPrompt("Upper bound for Y axis");
        this.yhiParam_.setDescription(new String[]{"<p>Upper bound for Y axis.", "Autogenerated from the data if not supplied.", "</p>"});
        this.ylogParam_ = new BooleanParameter("ylog");
        this.ylogParam_.setPrompt("Logarithmic Y axis?");
        this.ylogParam_.setDescription(new String[]{"<p>Whether to use a logarithmic scale for the Y axis.", "</p>"});
        this.ylogParam_.setDefault("false");
        this.binwidthParam_ = new DoubleParameter("binwidth");
        this.binwidthParam_.setPrompt("Bin width");
        this.binwidthParam_.setDescription(new String[]{"<p>Defines the width on the X axis of histogram bins.", "If the X axis is logarithmic, then this is a multiplicative", "value.", "</p>"});
        this.binwidthParam_.setNullPermitted(true);
        this.normParam_ = new BooleanParameter("norm");
        this.normParam_.setPrompt("Normalise bin sizes?");
        this.normParam_.setDescription(new String[]{"<p>Determines whether bin counts are normalised.", "If true, histogram bars are scaled such that", "summed height of all bars over the whole dataset is equal to one.", "Otherwise (the default), no scaling is done.", "</p>"});
        this.normParam_.setDefault("false");
        this.cumulativeParam_ = new BooleanParameter("cumulative");
        this.cumulativeParam_.setPrompt("Cumulative plot?");
        this.cumulativeParam_.setDescription(new String[]{"<p>Determines whether historams are cumulative.", "When false (the default), the height of each bar is determined", "by counting the number of points which fall into the range", "on the X axis that it covers.", "When true, the height is determined by counting all the points", "between negative infinity and the upper bound of the range", "on the X axis that it covers.", "</p>"});
        this.cumulativeParam_.setDefault("false");
        this.binbaseParam_ = new DoubleParameter("binbase");
        this.binbaseParam_.setPrompt("Lower bound for one histogram bin");
        this.binbaseParam_.setDescription(new String[]{"<p>Adjusts the offset of the bins.", "By default zero (or one for logarithmic X axis)", "is a boundary between bins;", "other boundaries are defined by this and the bin width.", "If this value is adjusted, the lower bound of one of the bins", "will be set to this value, so all the bins move along by the", "corresponding distance.", "</p>"});
        this.binbaseParam_.setDefault("0");
    }

    public Parameter[] getParameters() {
        String tSuffix = "N";
        ArrayList<Parameter> paramList = new ArrayList<Parameter>(Arrays.asList(super.getParameters()));
        paramList.add((Parameter)this.yloParam_);
        paramList.add((Parameter)this.yhiParam_);
        paramList.add((Parameter)this.ylogParam_);
        paramList.add(this.createWeightParameter(tSuffix));
        paramList.add((Parameter)this.binwidthParam_);
        paramList.add((Parameter)this.normParam_);
        paramList.add((Parameter)this.cumulativeParam_);
        paramList.add((Parameter)this.binbaseParam_);
        return paramList.toArray(new Parameter[0]);
    }

    protected PlotState createPlotState() {
        return new HistogramPlotState();
    }

    protected void configurePlotState(PlotState pstate, Environment env) throws TaskException {
        double bw;
        double ylo;
        super.configurePlotState(pstate, env);
        HistogramPlotState state = (HistogramPlotState)pstate;
        boolean xlog = state.getLogFlags()[0];
        boolean ylog = this.ylogParam_.booleanValue(env);
        state.setLogFlags(new boolean[]{xlog, ylog});
        state.setFlipFlags(new boolean[]{state.getFlipFlags()[0], false});
        if (ylog) {
            this.yloParam_.setNullPermitted(true);
            this.yloParam_.setDefault(null);
            ylo = this.yloParam_.doubleValue(env);
        } else {
            this.yloParam_.setNullPermitted(true);
            this.yloParam_.setDefault("0");
            double yl = this.yloParam_.doubleValue(env);
            ylo = Double.isNaN(yl) ? 0.0 : yl;
        }
        double yhi = this.yhiParam_.doubleValue(env);
        state.setRanges(new double[][]{state.getRanges()[0], {ylo, yhi}});
        this.binwidthParam_.setMinimum(xlog ? 1.0 : 0.0, false);
        double xlo = state.getRanges()[0][0];
        double xhi = state.getRanges()[0][1];
        if (!Double.isNaN(xlo) && !Double.isNaN(xhi)) {
            this.binwidthParam_.setNullPermitted(false);
            this.binwidthParam_.setDefault(Double.toString(this.getDefaultBinWidth(xlo, xhi, xlog)));
        }
        state.setBinWidth(Double.isNaN(bw = this.binwidthParam_.doubleValue(env)) ? 0.0 : bw);
        state.setNormalised(this.normParam_.booleanValue(env));
        state.setAxisLabels(new String[]{state.getAxisLabels()[0], Histogram.getYInfo(state.getWeighted(), state.getNormalised()).getName()});
        state.setNormalised(this.normParam_.booleanValue(env));
        state.setCumulative(this.cumulativeParam_.booleanValue(env));
        this.binbaseParam_.setDefault(state.getLogFlags()[0] ? "1" : "0");
        state.setBinBase(this.binbaseParam_.doubleValue(env));
    }

    protected TablePlotData createPlotData(Environment env, String tLabel, StarTable table, String[] setExprs, String[] setNames, Style[] setStyles, String labelExpr, String[] coordExprs, String[] errExprs) throws TaskException, CompilationException {
        coordExprs = new String[]{coordExprs[0], this.createWeightParameter(tLabel).stringValue(env)};
        return new CartesianTablePlotData(table, setExprs, setNames, setStyles, labelExpr, coordExprs, errExprs);
    }

    protected StyleFactory createStyleFactory(String prefix) {
        return new BarStyleFactory(prefix);
    }

    protected boolean requiresConfigureFromBounds(PlotState state) {
        for (int idim = 0; idim < 2; ++idim) {
            double[] range = state.getRanges()[idim];
            if (!Double.isNaN(range[0]) && !Double.isNaN(range[1])) continue;
            return true;
        }
        return false;
    }

    protected void configureFromBounds(PlotState pstate, DataBounds bounds) {
        HistogramPlotState state = (HistogramPlotState)pstate;
        boolean xlog = state.getLogFlags()[0];
        double[] stateXrange = state.getRanges()[0];
        double[] calcXrange = bounds.getRanges()[0].getFiniteBounds(xlog);
        boolean xloCalc = Double.isNaN(stateXrange[0]);
        boolean xhiCalc = Double.isNaN(stateXrange[1]);
        double xlo = xloCalc ? calcXrange[0] : stateXrange[0];
        double xhi = xhiCalc ? calcXrange[1] : stateXrange[1];
        double binBase = state.getBinBase();
        if (!(state.getBinWidth() > 0.0)) {
            state.setBinWidth(this.getDefaultBinWidth(xlo, xhi, xlog));
        }
        double binWidth = state.getBinWidth();
        if (xloCalc || xhiCalc) {
            double pad;
            MapBinnedData.BinMapper mapper = MapBinnedData.createBinMapper(xlog, binWidth, binBase);
            if (xloCalc) {
                xlo = mapper.getBounds(mapper.getKey(xlo))[0];
            }
            if (xhiCalc) {
                xhi = mapper.getBounds(mapper.getKey(xhi))[1];
            }
            if (xlog) {
                pad = Math.pow(xhi / xlo, 0.01);
                if (xloCalc) {
                    xlo /= pad;
                }
                if (xhiCalc) {
                    xhi *= pad;
                }
            } else {
                pad = (xhi - xlo) * 0.01;
                if (xloCalc) {
                    xlo -= pad;
                }
                if (xhiCalc) {
                    xhi += pad;
                }
            }
        }
        double ylo = state.getRanges()[1][0];
        double yhi = state.getRanges()[1][1];
        boolean ylog = state.getLogFlags()[1];
        boolean calcYlo = Double.isNaN(ylo);
        boolean calcYhi = Double.isNaN(yhi);
        if (!$assertionsDisabled && !ylog && calcYlo) {
            throw new AssertionError();
        }
        if (calcYlo || calcYhi) {
            int nset = state.getPlotData().getSetCount();
            boolean norm = state.getNormalised();
            boolean cumulative = state.getCumulative();
            MapBinnedData.BinMapper mapper = MapBinnedData.createBinMapper(xlog, binWidth, binBase);
            BinnedData binData = new MapBinnedData(nset, mapper);
            if (norm) {
                binData = new NormalisedBinnedData(binData);
            }
            boolean[] setFlags = new boolean[nset];
            PointSequence pseq = state.getPlotData().getPointSequence();
            while (pseq.next()) {
                double[] coords = pseq.getPoint();
                double x = coords[0];
                double w = coords[1];
                if (!(x >= xlo) || !(x <= xhi) || Double.isNaN(w)) continue;
                for (int is = 0; is < nset; ++is) {
                    setFlags[is] = pseq.isIncluded(is);
                }
                binData.submitDatum(x, w, setFlags);
            }
            pseq.close();
            double[] sums = new double[nset];
            Range range = new Range();
            Iterator binIt = binData.getBinIterator(false);
            while (binIt.hasNext()) {
                BinnedData.Bin bin = (BinnedData.Bin)binIt.next();
                for (int is = 0; is < nset; ++is) {
                    double s = bin.getWeightedCount(is);
                    int n = is;
                    sums[n] = sums[n] + s;
                    range.submit(cumulative ? sums[is] : s);
                }
            }
            double[] ybounds = range.getFiniteBounds(ylog);
            if (calcYlo) {
                ylo = ybounds[0];
            }
            if (calcYhi) {
                yhi = ybounds[1];
            }
            if (ylog) {
                if (calcYlo) {
                    ylo /= Math.pow(yhi / ylo, 0.01);
                }
                if (calcYhi) {
                    yhi *= Math.pow(yhi / ylo, 0.01);
                }
            } else {
                if (calcYlo && ylo != 0.0) {
                    ylo -= (yhi - ylo) * 0.01;
                }
                if (calcYhi) {
                    yhi += (yhi - ylo) * 0.01;
                }
            }
        }
        state.setRanges(new double[][]{{xlo, xhi}, {ylo, yhi}});
    }

    private double getDefaultBinWidth(double xlo, double xhi, boolean xlog) {
        int nbin = 20;
        return xlog ? Rounder.LOG.round(Math.exp(Math.log(xhi / xlo) / (double)nbin)) : Rounder.LINEAR.round((xhi - xlo) / (double)nbin);
    }

    private Parameter createWeightParameter(String tlabel) {
        Parameter param = new Parameter("weight" + tlabel);
        param.setPrompt("Histogram weighting for table " + tlabel);
        param.setDescription(new String[]{"<p>Defines a weighting for each point accumulated to determine", "the height of plotted bars.", "If this parameter has a value other than 1 (the default)", "then instead of simply accumulating the number of points per bin", "to determine bar height,", "the bar height will be the sum over the weighting expression", "for the points in each bin.", "Note that with weighting, the figure drawn is no longer", "strictly speaking a histogram.", "</p>", "<p>When weighted, bars can be of negative height.", "An anomaly of the plot as currently implemented is that the", "Y axis never descends below zero, so any such bars are currently", "invisible.", "This may be amended in a future release", "(contact the author to lobby for such an amendment).", "</p>"});
        param.setDefault("1");
        return param;
    }

    static {
        $assertionsDisabled = !HistogramPlotStateFactory.class.desiredAssertionStatus();
    }
}

