/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.meta;

import alma.acs.commandcenter.meta.IMaciSupervisor;
import alma.acs.commandcenter.meta.MaciSupervisor;
import alma.maciErrType.CannotDeactivateComponentEx;
import alma.maciErrType.CannotGetComponentEx;
import alma.maciErrType.ComponentConfigurationNotFoundEx;
import alma.maciErrType.ComponentDeactivationFailedEx;
import alma.maciErrType.ComponentDeactivationUncleanEx;
import alma.maciErrType.ComponentNotAlreadyActivatedEx;
import alma.maciErrType.NoPermissionEx;
import alma.maciErrType.wrappers.AcsJCannotDeactivateComponentEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationFailedEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationUncleanEx;
import java.util.List;
import java.util.logging.Logger;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import si.ijs.maci.ClientInfo;
import si.ijs.maci.ContainerInfo;

public class GuiMaciSupervisor
extends MaciSupervisor {
    public GuiMaciSupervisor(String clientName, String managerLoc, ORB orb, Logger log) {
        super(clientName, managerLoc, orb, log);
    }

    public void managerPing() throws IMaciSupervisor.NotConnectedToManagerException, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending ping request to manager (" + this.getManagerLocation() + ")");
            this.myManagerReference().ping();
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void managerShutdown() throws IMaciSupervisor.NotConnectedToManagerException, IMaciSupervisor.CorbaNoPermissionException, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending shutdown request to manager (" + this.getManagerLocation() + ")");
            int hhhhh = this.myMaciHandle();
            this.myManagerReference().shutdown(hhhhh, 0);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NO_PERMISSION exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNoPermissionException(exc);
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void managerLogout(ContainerInfo info) throws IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending logout request to manager to log out container '" + info.name + "'");
            this.myManagerReference().logout(info.h);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NoPermissionEx exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void managerLogout(ClientInfo info) throws IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending logout request to manager to log out client '" + info.name + "'");
            this.myManagerReference().logout(info.h);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NoPermissionEx exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public Object managerGetComponent(String curl) throws ComponentNotAlreadyActivatedEx, CannotGetComponentEx, ComponentConfigurationNotFoundEx, IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending get_component request for '" + curl + "'");
            int hhhhh = this.myMaciHandle();
            Object stub = this.myManagerReference().get_component(hhhhh, curl, true);
            this.log.fine("successfully retrieved component '" + curl + "'");
            return stub;
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NoPermissionEx exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public Object managerGetComponentNonSticky(String curl) throws ComponentNotAlreadyActivatedEx, CannotGetComponentEx, IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending get_component_non_sticky request for '" + curl + "'");
            int hhhhh = this.myMaciHandle();
            Object stub = this.myManagerReference().get_component_non_sticky(hhhhh, curl);
            this.log.fine("successfully retrieved component '" + curl + "' as non_sticky");
            return stub;
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NoPermissionEx exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void managerReleaseComponents(String[] curls) throws IMaciSupervisor.UnknownErrorException, IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.CorbaUnknownException, AcsJCannotDeactivateComponentEx, AcsJComponentDeactivationUncleanEx, AcsJComponentDeactivationFailedEx {
        try {
            this.log.fine("sending release_component requests to manager");
            int hhhhh = this.myMaciHandle();
            for (int i = 0; i < curls.length; ++i) {
                this.myManagerReference().release_component(hhhhh, curls[i]);
            }
        }
        catch (UNKNOWN exc) {
            throw new IMaciSupervisor.CorbaUnknownException(exc);
        }
        catch (CannotDeactivateComponentEx ex) {
            throw AcsJCannotDeactivateComponentEx.fromCannotDeactivateComponentEx((CannotDeactivateComponentEx)ex);
        }
        catch (ComponentDeactivationUncleanEx ex) {
            throw AcsJComponentDeactivationUncleanEx.fromComponentDeactivationUncleanEx((ComponentDeactivationUncleanEx)ex);
        }
        catch (ComponentDeactivationFailedEx ex) {
            throw AcsJComponentDeactivationFailedEx.fromComponentDeactivationFailedEx((ComponentDeactivationFailedEx)ex);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NoPermissionEx exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void managerForceReleaseComponent(String curl) throws IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending force_release_component request to manager");
            int hhhhh = this.myMaciHandle();
            this.myManagerReference().force_release_component(hhhhh, curl);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NoPermissionEx exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void containerDisconnect(ContainerInfo info) throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending disconnect request to container '" + info.name + "'");
            info.reference.disconnect();
        }
        catch (TRANSIENT exc) {
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (RuntimeException exc) {
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void containerPing(ContainerInfo info) throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending ping request to container '" + info.name + "'");
            info.reference.ping();
        }
        catch (TRANSIENT exc) {
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (RuntimeException exc) {
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void containerShutdown(ContainerInfo info) throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending shutdown request to container '" + info.name + "'");
            int action = 512;
            info.reference.shutdown(action);
        }
        catch (TRANSIENT exc) {
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (RuntimeException exc) {
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void containerMessage(ContainerInfo info, short msgType, String msg) throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending message to container '" + info.name + "'");
            info.reference.message(msgType, msg);
        }
        catch (TRANSIENT exc) {
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (RuntimeException exc) {
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void containersShutdown() throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        List<ContainerInfo> cc = this.maciInfo.getContainers();
        for (ContainerInfo c : cc) {
            this.containerShutdown(c);
        }
    }

    public void clientDisconnect(ClientInfo info) throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending disconnect request to client '" + info.name + "'");
            info.reference.disconnect();
        }
        catch (TRANSIENT exc) {
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (RuntimeException exc) {
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void clientPing(ClientInfo info) throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending ping request to client '" + info.name + "'");
            info.reference.ping();
        }
        catch (TRANSIENT exc) {
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (RuntimeException exc) {
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    public void clientMessage(ClientInfo info, short msgType, String msg) throws IMaciSupervisor.CorbaTransientException, IMaciSupervisor.UnknownErrorException {
        try {
            this.log.fine("sending message to client '" + info.name + "'");
            info.reference.message(msgType, msg);
        }
        catch (TRANSIENT exc) {
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (RuntimeException exc) {
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }
}

