/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.task.LineEnvironment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class MultiTaskInvoker {
    private final String toolName_;
    private final ObjectFactory taskFactory_;
    private String versionMessage_;

    public MultiTaskInvoker(String toolName, ObjectFactory taskFactory) {
        this.toolName_ = toolName;
        this.taskFactory_ = taskFactory;
    }

    public int invoke(String[] args) {
        String arg1;
        Task task;
        String arg;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean debug = false;
        boolean bench = false;
        int verbose = 0;
        Iterator it = argList.iterator();
        while (it.hasNext() && (arg = (String)it.next()).charAt(0) == '-') {
            if ("-help".equals(arg)) {
                it.remove();
                System.out.println(this.getUsage());
                return 0;
            }
            if ("-debug".equals(arg)) {
                it.remove();
                debug = true;
                continue;
            }
            if ("-verbose".equals(arg)) {
                it.remove();
                ++verbose;
                continue;
            }
            if ("-version".equals(arg) && this.getVersionMessage() != null) {
                it.remove();
                System.out.println(this.getVersionMessage());
                return 0;
            }
            if ("-bench".equals(arg)) {
                it.remove();
                bench = true;
                continue;
            }
            if (arg.charAt(0) != '-') break;
            it.remove();
            System.err.println(this.getUsage());
            return 1;
        }
        InvokeUtils.configureLogging(verbose, debug);
        if (argList.size() == 0) {
            System.err.println(this.getUsage());
            return 1;
        }
        String taskName = (String)argList.remove(0);
        try {
            task = (Task)this.taskFactory_.createObject(taskName);
        }
        catch (LoadException e) {
            System.err.println("No such task " + taskName);
            System.err.println(this.getUsage());
            return 1;
        }
        if (argList.size() > 0 && ((arg1 = ((String)argList.get(0)).toLowerCase()).startsWith("-help") || arg1.equals("help"))) {
            System.out.println(this.getUsage(taskName, task));
            return 0;
        }
        String[] taskArgs = argList.toArray(new String[0]);
        try {
            LineEnvironment env = new LineEnvironment(taskArgs, task.getParameters());
            long start = System.currentTimeMillis();
            Executable exec = task.createExecutable(env);
            exec.execute();
            if (bench) {
                long millis = System.currentTimeMillis() - start;
                String secs = Float.toString((float)(millis / 100L) * 0.1f);
                System.err.println("Elapsed time: " + secs + "s");
            }
            return 0;
        }
        catch (Exception e) {
            if (debug) {
                System.err.println();
                e.printStackTrace(System.err);
            }
            System.err.println();
            InvokeUtils.summariseError(e, System.err);
            if (!(e instanceof ParameterValueException) && !(e instanceof IOException)) {
                if (e instanceof UsageException) {
                    System.err.println();
                    System.err.println(this.getUsage(taskName, task));
                } else if (e instanceof AbortException) {
                    System.err.println();
                    System.err.println("User abort");
                } else if (!debug) {
                    System.err.println();
                    e.printStackTrace(System.err);
                }
            }
            return 1;
        }
    }

    public void setVersionMessage(String msg) {
        this.versionMessage_ = msg;
    }

    public String getVersionMessage() {
        return this.versionMessage_;
    }

    private String getUsage(String taskName, Task task) {
        StringBuffer ubuf = new StringBuffer();
        ubuf.append("Usage: ").append(this.toolName_).append(' ').append(taskName);
        String padding = ubuf.toString().replaceAll(".", " ") + " ";
        ubuf.append("\n");
        Parameter[] params = InvokeUtils.sortParameters(task.getParameters());
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            ubuf.append(padding);
            boolean optional = param.isNullPermitted() || param.getDefault() != null;
            ubuf.append(optional ? "[" : "").append(param.getName()).append('=').append(param.getUsage()).append(optional ? "]" : "").append("\n");
        }
        return "\n" + ubuf.toString();
    }

    private String getUsage() {
        StringBuffer sbuf = new StringBuffer().append("Usage:\n");
        String pad1 = "   ";
        String pad = (pad1 + this.toolName_).replaceAll(".", " ");
        sbuf.append(pad1).append(this.toolName_).append(" [-help]");
        if (this.getVersionMessage() != null) {
            sbuf.append(" [-version]");
        }
        sbuf.append(" [-verbose]").append(" [-debug]").append(" [-bench]").append('\n').append(pad).append(" <task-name> <task-args>").append('\n').append('\n');
        sbuf.append(pad1).append(this.toolName_).append(" <task-name> -help").append("\n").append("\n");
        sbuf.append("   Known tasks:\n");
        String[] tasks = this.taskFactory_.getNickNames();
        for (int i = 0; i < tasks.length; ++i) {
            sbuf.append("      ").append(tasks[i]).append("\n");
        }
        return "\n" + sbuf.toString();
    }
}

