/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.util.Destination;

public class OutputStreamParameter
extends Parameter {
    private Destination destination_;

    public OutputStreamParameter(String name) {
        super(name);
        this.setUsage("<out-file>");
        this.setPrompt("Location of output file");
        this.setDefault("-");
        this.setDescription(new String[]{"<p>The location of the output file.  This is usually a filename", "to write to.", "If it is equal to the special value \"-\"", "the output will be written to standard output.", "</p>"});
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        if (sval == null || sval.trim().length() == 0) {
            this.destination_ = null;
        } else if ("-".equals(sval)) {
            final PrintStream out = env.getOutputStream();
            this.destination_ = new Destination(){

                public OutputStream createStream() {
                    return out;
                }
            };
        } else {
            final File file = new File(sval);
            File parentDir = new File(sval).getAbsoluteFile().getParentFile();
            if (!parentDir.exists()) {
                throw new ParameterValueException((Parameter)this, "Bad pathname (no dir?)");
            }
            this.destination_ = new Destination(){

                public OutputStream createStream() throws IOException {
                    return new FileOutputStream(file);
                }
            };
        }
        super.setValueFromString(env, sval);
    }

    public Destination destinationValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.destination_;
    }
}

