/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import com.cosylab.logging.client.EntryTypeIcon;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class LogTypeRenderer
extends JLabel
implements ListCellRenderer {
    public LogTypeRenderer() {
        this.setPreferredSize(new Dimension(100, EntryTypeIcon.getIconsVSize()));
        this.setOpaque(true);
        this.setVerticalTextPosition(0);
        this.setHorizontalTextPosition(11);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value == null) {
            this.setIcon(null);
            return this;
        }
        this.setText(value.toString());
        this.setFont(list.getFont());
        if (value instanceof LogTypeHelper) {
            this.setIcon(EntryTypeIcon.getIcon((LogTypeHelper)value));
        } else if (!value.toString().equals("None")) {
            LogTypeHelper logType = LogTypeHelper.fromLogTypeDescription((String)value.toString());
            if (logType != null) {
                this.setIcon(EntryTypeIcon.getIcon(logType));
            }
        } else {
            this.setIcon(null);
        }
        return this;
    }
}

