/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.UncompressInputStream;

public abstract class Compression {
    private String name;
    public static final int MAGIC_SIZE = 3;
    public static final Compression NONE = new Compression("none"){

        public InputStream decompress(InputStream raw) throws IOException {
            return raw;
        }
    };
    public static final Compression GZIP = new Compression("gzip"){

        public InputStream decompress(InputStream raw) throws IOException {
            return new GZIPInputStream(raw){

                public boolean markSupported() {
                    return false;
                }
            };
        }
    };
    public static final Compression BZIP2 = new Compression("bzip2"){

        public InputStream decompress(InputStream raw) throws IOException {
            if (raw.read() != 66 || raw.read() != 90) {
                throw new IllegalArgumentException("Wrong magic number for bzip2 encoding");
            }
            return new CBZip2InputStream(raw);
        }
    };
    public static final Compression COMPRESS = new Compression("compress"){

        public InputStream decompress(InputStream raw) throws IOException {
            return new UncompressInputStream(raw);
        }
    };

    private Compression(String name) {
        this.name = name;
    }

    public abstract InputStream decompress(InputStream var1) throws IOException;

    public static Compression getCompression(byte[] magic) {
        if (magic.length < 3) {
            throw new IllegalArgumentException("Magic buffer must be at least MAGIC_SIZE=3 bytes");
        }
        if (magic[0] == 31 && magic[1] == -117) {
            return GZIP;
        }
        if (magic[0] == 66 && magic[1] == 90 && magic[2] == 104) {
            return BZIP2;
        }
        if (magic[0] == 31 && magic[1] == -99) {
            return COMPRESS;
        }
        return NONE;
    }

    public static InputStream decompressStatic(InputStream raw) throws IOException {
        if (!raw.markSupported() || DataSource.getMarkWorkaround()) {
            raw = new BufferedInputStream(raw);
        }
        raw.mark(3);
        byte[] buf = new byte[3];
        raw.read(buf);
        raw.reset();
        Compression compress = Compression.getCompression(buf);
        return compress.decompress(raw);
    }

    public String toString() {
        return this.name;
    }
}

