/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import jsky.catalog.AbstractSearchCondition;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;

public class ArraySearchCondition
extends AbstractSearchCondition {
    private static final long serialVersionUID = 1L;
    private Object[] _values;

    public ArraySearchCondition(FieldDesc fieldDesc, Object[] values) {
        super(fieldDesc);
        this._values = values;
    }

    public Object[] getValues() {
        return this._values;
    }

    @Override
    public boolean isTrueFor(Comparable val) {
        if (this._values == null || this._values.length == 0) {
            return true;
        }
        for (Object value : this._values) {
            if (val == null && value == null) {
                return true;
            }
            if (!(val instanceof Comparable) || !(value instanceof Comparable) || ((Comparable)value).compareTo(val) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTrueFor(double val) {
        return this.isTrueFor(new Double(val));
    }

    @Override
    public String getValueAsString() {
        String sep = "";
        StringBuffer sb = new StringBuffer();
        for (Object _value : this._values) {
            sb.append(sep);
            sb.append(_value.toString());
            sep = ",";
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ArraySearchCondition s = new ArraySearchCondition(new FieldDescAdapter("X"), new String[]{"AAA", "BBB", "CCC"});
        if (!s.isTrueFor((Comparable)((Object)"BBB"))) {
            throw new RuntimeException("test failed for BBB: " + s);
        }
        if (s.isTrueFor((Comparable)((Object)"CXX"))) {
            throw new RuntimeException("test failed for CXX: " + s);
        }
        System.out.println("All tests passed");
    }
}

