/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.obsprep.bo.annotations.ACASpectralWindowI;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.ACASpectralWindow;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ACASpectralWindowPair
extends SpectralWindowPair
implements ACASpectralWindowI {
    public ACASpectralWindowPair(AbstractBaseBandConfig abstractBaseBandConfig) {
        super(abstractBaseBandConfig);
    }

    @Override
    public void addSpectralLine(SpectralSpec.SideBand sideBand, SpectralLine spectralLine) {
        if (sideBand.equals((Object)SpectralSpec.SideBand.LSB)) {
            this.getLSB().addSpectralLine(spectralLine);
        } else {
            this.getUSB().addSpectralLine(spectralLine);
        }
    }

    @Override
    public void clearSpectralLines(SpectralSpec.SideBand sideBand) {
        if (sideBand.equals((Object)SpectralSpec.SideBand.LSB)) {
            this.getLSB().clearSpectralLine();
        } else {
            this.getUSB().clearSpectralLine();
        }
    }

    public ACASpectralWindow getLSB() {
        return (ACASpectralWindow)((Object)super.getLSB());
    }

    public ACASpectralWindow getUSB() {
        return (ACASpectralWindow)((Object)super.getUSB());
    }

    @Override
    public boolean getFrqChProfReproduction() {
        return this.getLSB().getFrqChProfReproduction();
    }

    @Override
    public void setFrqChProfReproduction(boolean bl) {
        this.getLSB().setFrqChProfReproduction(bl);
        this.getUSB().setFrqChProfReproduction(bl);
    }

    @Override
    public ACASpectralWindowPair getNewInstance(AbstractBaseBandConfig abstractBaseBandConfig) {
        return new ACASpectralWindowPair(abstractBaseBandConfig);
    }

    @Override
    public CorrConfigMode getCorrConfigMode() {
        return this.getLSB().getCorrConfigMode();
    }

    @Override
    public String getFilterMode() {
        return this.getLSB().getFilterMode();
    }

    @Override
    public void updateCorrConfigMode() {
    }

    @Override
    public void addSpectralLine(SpectralLine spectralLine) {
        this.getUSB().addSpectralLine(spectralLine);
        this.getLSB().addSpectralLine(spectralLine);
    }

    @Override
    public String getSynthProf() {
        return this.getLSB().getSynthProf();
    }

    @Override
    public void setSynthProf(String string) {
        this.getLSB().setSynthProf(string);
        this.getUSB().setSynthProf(string);
    }

    @Override
    public ScienceSpectralWindow getScienceSpectralWindow() {
        SpectralWindowI[] spectralWindowIArray = this.bbc.getSpectralWindow();
        if (spectralWindowIArray.length > 0) {
            return spectralWindowIArray[0].getLSB().getScienceSpectralWindow();
        }
        throw new RuntimeException("No spectral windows found when expected");
    }

    @Override
    public List<SpectralLine> getSpectralLines() {
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
        arrayList.addAll(Arrays.asList(this.getLSB().getSpectralLine()));
        arrayList.addAll(Arrays.asList(this.getUSB().getSpectralLine()));
        return arrayList;
    }

    @Override
    public String getGroupingIdentifier() {
        return this.getLSB().getGroupingIdentifier();
    }
}

