/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc;

import alma.obsprep.guiutil.mvc.Controller;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.ModelStatusSubscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;

public abstract class Model
implements Iterable<Model> {
    private final Controller controller;
    protected boolean isModelInTransitionState = false;
    protected Object document;
    private final List<Model> subModels = new ArrayList<Model>();
    private Model parentModel;

    public Model(Object object) {
        this.document = object;
        this.controller = new Controller(this);
    }

    public abstract void publish();

    public void publish(FieldID fieldID, Object object) {
        this.controller.modelChanged(fieldID, object);
    }

    public void fieldInvalid(FieldID fieldID, String string) {
        this.controller.fieldInvalid(fieldID, string);
    }

    public void fieldValid(FieldID fieldID) {
        this.controller.fieldValid(fieldID);
    }

    public void publishSubmodels() {
        this.publishSubmodels(this.subModels);
    }

    private void publishSubmodels(List<Model> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        list.stream().forEach(model -> {
            model.publishSubmodels(model.getSubModels());
            model.publish();
        });
    }

    public void setDocument(Object object) {
        this.document = object;
        this.publish();
    }

    public void setonlyDocument(Object object) {
        this.document = object;
    }

    public void subscribe(ModelChangeSubscriber modelChangeSubscriber) {
        this.getController().subscribe(modelChangeSubscriber);
    }

    public void subscribe(ModelStatusSubscriber modelStatusSubscriber) {
        this.getController().subscribe(modelStatusSubscriber);
    }

    public void unsubscribe(ModelChangeSubscriber modelChangeSubscriber) {
        this.getController().unsubscribe(modelChangeSubscriber);
    }

    public void unsubscribe(ModelStatusSubscriber modelStatusSubscriber) {
        this.getController().unsubscribe(modelStatusSubscriber);
    }

    public abstract Object update(Editor var1, FieldID var2, Object var3);

    public Object get(FieldID fieldID) {
        String string = "Method get(FieldID) must be overridden in class " + this.getClass().getName();
        throw new RuntimeException(string);
    }

    public Model submodel(int n) {
        return this.subModels.get(n);
    }

    public void registerSubModel(Model ... modelArray) {
        if (modelArray == null) {
            throw new NullPointerException("subModel is marked non-null but is null");
        }
        for (Model model : modelArray) {
            if (this.subModels.contains(model)) continue;
            model.setParentModel(this);
            this.subModels.add(model);
        }
    }

    public boolean forgetSubModel(Model model) {
        model.setParentModel(null);
        return this.subModels.remove(model);
    }

    @Override
    public Iterator<Model> iterator() {
        return this.subModels.iterator();
    }

    public Stream<Model> stream() {
        return this.subModels.stream();
    }

    public void subscribeToAllRegisteredModels(@NonNull ModelChangeSubscriber modelChangeSubscriber) {
        if (modelChangeSubscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        this.subscribe(modelChangeSubscriber);
        for (Model model : this.subModels) {
            model.subscribeToAllRegisteredModels(modelChangeSubscriber);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public void setModelInTransitionState(boolean bl) {
        this.isModelInTransitionState = bl;
    }

    public Object getDocument() {
        return this.document;
    }

    public List<Model> getSubModels() {
        return this.subModels;
    }

    public void setParentModel(Model model) {
        this.parentModel = model;
    }

    public Model getParentModel() {
        return this.parentModel;
    }
}

