/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.GenerateWholePDFInteractor;
import alma.obsprep.ot.actions.GenerateWholePDFPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.project.ProjectTreeNode;

public class GenerateWholePDFAction
extends OTAction
implements GenerateWholePDFInteractor,
EventReceiver {
    private static final long serialVersionUID = 8018069175523233363L;
    protected BusinessObject m_selectedBO = null;
    protected ProjectTreeNode m_selectedNode = null;

    public GenerateWholePDFAction() {
        GenerateWholePDFPerformer generateWholePDFPerformer = new GenerateWholePDFPerformer(this);
        this.setPerformer(generateWholePDFPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public ObsProposal getProposal() {
        BusinessObject businessObject = this.m_selectedBO;
        ObsProject obsProject = businessObject.findProject();
        if (obsProject != null) {
            try {
                return obsProject.getObsProposal();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger((Object)this).warning(unknownEntityException.getMessage());
            }
        }
        return null;
    }

    private void enableForAnyValidProject(BusinessObject businessObject) {
        ObsProject obsProject = businessObject.findProject();
        if (null == obsProject || obsProject.getIsCommissioning()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.enableForAnyValidProject(this.m_selectedBO);
    }
}

